/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.test;

import java.io.*;
import java.util.*;
import java.net.*;

import junit.extensions.*;
import junit.framework.*;

import org.netbeans.api.mdr.*;
import org.openide.util.Lookup;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

/**
 * Multivalued index test case.
 */
public class TransactionTest extends MDRTestCase {

    private static final int MAX = 500;
    private static int counter = 0;
    private Random random = new Random (0);
    
    public TransactionTest(String testName) {
        super (testName);
    }
    
    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite ());
    }
    
    public static Test suite () {
        TestSuite suite = new TestSuite ();
        suite.addTestSuite (TransactionTest.class);
        
        TestSetup setup = new TestSetup (suite) {
            public void setUp () {
//                org.netbeans.mdr.handlers.BaseObjectHandler.setDefaultClassLoader (this.getClass ().getClassLoader ());
            }
            public void tearDown () {
            }
        };
        return setup;
    }
    
    public void test () {
        int x;
        VisibilityKindEnum visKind = null;
        Contains assoc = modelPackage.getContains ();
        MofClass mainClass = generateClass ();
        AttributeClass attribClass = modelPackage.getAttribute ();

        int classes_incr, links_incr;
        int classes_num = modelPackage.getMofClass ().refAllOfType ().size ();
        int links_num = assoc.refQuery ("container", mainClass).size ();
        
        // start with one rollback ...
        try {
            repository.beginTrans (true);            
        } catch (Exception e) {
            e.printStackTrace ();
            fail (e.getMessage ());
        } finally {
            repository.endTrans (true);
        }
        
        // test rollback of attribute values
        final int VIS_NUM = 50;
        Attribute [] attrib = new Attribute [VIS_NUM];
        VisibilityKind [] vis = new VisibilityKind [VIS_NUM];
        
        for (x = 0; x < VIS_NUM; x++) {
            attrib [x] = attribClass.createAttribute ();
            int rnd = random.nextInt (3);
            switch (rnd) {
                case 0: visKind = VisibilityKindEnum.PUBLIC_VIS; break;
                case 1: visKind = VisibilityKindEnum.PROTECTED_VIS; break;
                case 2: visKind = VisibilityKindEnum.PRIVATE_VIS; break;
            }
            attrib [x].setVisibility (visKind);
            vis [x] = visKind;
        }
        try {
            repository.beginTrans (true);
            for (x = 0; x < VIS_NUM; x++) {
                int rnd = random.nextInt (3);
                switch (rnd) {
                    case 0: visKind = VisibilityKindEnum.PUBLIC_VIS; break;
                    case 1: visKind = VisibilityKindEnum.PROTECTED_VIS; break;
                    case 2: visKind = VisibilityKindEnum.PRIVATE_VIS; break;
                }
                attrib [x].setVisibility (visKind);
            }
        } catch (Exception e) {
            e.printStackTrace ();
            fail (e.getMessage ());
        } finally {
            repository.endTrans (true);
        }
        // check if all values have been rolled back
        for (x = 0; x < VIS_NUM; x++) {
            if (attrib [x].getVisibility () != vis[x])
                fail ();
        }
        
        // a sequence of random commits and rollbacks follows ...
        for (int y = 0; y < 100; y++) {
            classes_incr = links_incr = 0;
            boolean rollback = (random.nextInt (3) == 2);
            try {
                repository.beginTrans (true);
                int top = 10 + random.nextInt (MAX);
                for (x = 0; x < top; x++) {
                    MofClass obj = generateClass ();
                    classes_incr++;
                    if (random.nextInt (3) == 1) {
                        obj.refDelete ();
                        classes_incr--;
                    } else if (random.nextInt (6) == 1) {
                        obj.setContainer (mainClass);
                        links_incr++;
                    }
                } // for
            } catch (Exception e) {
                e.printStackTrace ();
                fail (e.getMessage ());
            } finally {
                repository.endTrans (rollback);
            }
            
            if (!rollback) {
                classes_num += classes_incr;
                links_num += links_incr;
            }

            if (classes_num != modelPackage.getMofClass ().refAllOfType ().size ()) {
                fail ("number of instances does not match: " + classes_num);
            }
            if (links_num != assoc.refQuery ("container", mainClass).size ()) {
                fail ("number of links does not match: " + links_num);
            }
            
        } // for
        
    }
    
    public void testMemoryStorage () {
        System.setProperty("org.netbeans.mdr.persistence.memoryimpl.persistent", "false");
        System.setProperty("org.netbeans.mdr.storagemodel.StorageFactoryClassName",
            "org.netbeans.mdr.persistence.memoryimpl.StorageFactoryImpl");
        test ();
    }
        
    private MofClass generateClass () {
        MofClassClass proxy = modelPackage.getMofClass ();
        return proxy.createMofClass ("name" + counter++, "", true, true, true, VisibilityKindEnum.PUBLIC_VIS, true);
    }
    
    private void printListElements (List list) {
        Iterator iter = list.iterator ();
        System.out.println("list size: " + list.size () + " " + list.getClass ().getName ());
        while (iter.hasNext ()) {
            ModelElement element = (ModelElement) iter.next ();
            System.out.println((element != null ? element.getName () : "null") + " ");
        }
        System.out.println("");
    }
    
}