/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.test;

import java.io.*;
import java.util.*;
import java.net.*;

import junit.extensions.*;
import junit.framework.*;

import org.netbeans.api.mdr.*;
import org.openide.util.Lookup;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.*;

import org.netbeans.mdr.persistence.*;
import org.netbeans.mdr.storagemodel.*;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.*;
import org.netbeans.mdr.persistence.memoryimpl.*;

import org.xml.sax.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

public class QueryByPrefixTest extends MDRTestCase {
        
    public static Random random = new Random ();
    
    public QueryByPrefixTest(String testName) {
        super (testName);
    }
    
    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite ());
    }
    
    public static Test suite () {
        TestSuite suite = new TestSuite ();
        suite.addTestSuite (QueryByPrefixTest.class);
        
        TestSetup setup = new TestSetup (suite) {
            public void setUp () {
            }
            public void tearDown () {
            }
        };        
        return setup;        
    }

    protected void setUp () {
    }
    
    // **************************************************************************
    
    public void testBtreeStorage () {
        try {
            StorageFactory factory = new BtreeFactory ();
            Storage storage = factory.createStorage (new HashMap ());
            storage.create (true, new Resolver ());

            doSingleTest (storage);
            doMultiTest (storage);

            storage.close ();            
        } catch (Exception e) {
            e.printStackTrace ();
            fail (e.getMessage ());
        }
    }
    
    public void testMemoryStorage () {
        try {
            StorageFactory factory = new StorageFactoryImpl ();
            Storage storage = factory.createStorage (new HashMap ());
            storage.create (true, new Resolver ());

            doSingleTest (storage);
            doMultiTest (storage);

            storage.close ();            
        } catch (Exception e) {
            e.printStackTrace ();
            fail (e.getMessage ());
        }
    }
    
    public void doSingleTest (Storage storage) {
        try {          
            SinglevaluedIndex primaryIndex = storage.getPrimaryIndex ();
            
            Storage.EntryType entryType = Storage.EntryType.STRING;
            SinglevaluedIndex index = storage.createSinglevaluedIndex (
                "singleIndex", entryType, entryType);
                        
            final int MAX = 10000;
            final int PREFIXES_NUM = 50;
            final int MAX_2 = 50;
            
            final String LAST_ELEMENT = "ZZZZZ";            
            
            String [] prefixes = new String [PREFIXES_NUM];
            int [] counts = new int [PREFIXES_NUM];
            
            for (int x = 0; x < PREFIXES_NUM; x++) {
                counts [x] = 0;
                prefixes [x] = randomString ("" + (char)('a' + x), 5, 8);
            }
            for (int x = 0; x < MAX; x++) {
                String s = randomString ("");
                if (index.getIfExists (s) == null) {
                    index.add (s, s);                    
                    for (int y = 0; y < PREFIXES_NUM; y++) {
                        if (s.startsWith (prefixes [y]))
                            counts [y]++;
                    } // for
                }
            } // for
            for (int x = 0; x < PREFIXES_NUM; x++) {
                int num = random.nextInt (MAX_2);
                for (int y = 0; y < num; y++) {
                    String s = randomString (prefixes [x]);
                    if (index.getIfExists (s) == null) {
                        index.add (s,s);
                        counts [x] ++;
                    }
                }
                if (random.nextBoolean () && (index.getIfExists (prefixes[x]) == null)) {                    
                    index.add (prefixes[x], prefixes[x]);
                    counts [x] ++;
                }
            }
            
            
            for (int x = 0; x < PREFIXES_NUM; x++) {
                // query keys starting with the specified prefix ...
                Collection list = index.queryByKeyPrefix (prefixes [x], primaryIndex);
                if (counts [x] != list.size ()) {
                    fail("#" + x + ", " + prefixes [x] + ": found " 
                        +  list.size () + ", expected " + counts [x]);
                }
                for (Iterator iter = list.iterator (); iter.hasNext ();) {
                    Map.Entry entry = (Map.Entry) iter.next ();                    
                    if (!entry.getValue ().equals (entry.getKey ())) {
                        fail ();
                    }
                }  // for
            }                        
            
            // should return an empty collection
            Collection list = index.queryByKeyPrefix ("000", primaryIndex);            
            if (list.size () != 0) {
                fail(list.size () + " != 0");
            }
            
            index.add (LAST_ELEMENT, LAST_ELEMENT);
            list = index.queryByKeyPrefix (LAST_ELEMENT, primaryIndex);            
            if (list.size () != 1) {
                fail(list.size () + " != 1");
            }
            
            storage.commitChanges ();                        
        } catch (Exception e) {
            e.printStackTrace ();
            fail ();
        }
    }

    public void doMultiTest (Storage storage) {
        try {                        
            SinglevaluedIndex primaryIndex = storage.getPrimaryIndex ();
            
            Storage.EntryType entryType = Storage.EntryType.STRING;
            MultivaluedIndex index = storage.createMultivaluedIndex (
                "multiIndex", entryType, entryType, false);
                        
            final int MAX = 10000;
            final int PREFIXES_NUM = 50;
            final int MAX_2 = 50;
            
            final String LAST_ELEMENT = "ZZZZZ";            
            
            String [] prefixes = new String [PREFIXES_NUM];
            int [] counts = new int [PREFIXES_NUM];
            
            for (int x = 0; x < PREFIXES_NUM; x++) {
                counts [x] = 0;
                prefixes [x] = randomString ("" + (char)('a' + x), 5, 8);
            }
            for (int x = 0; x < MAX; x++) {
                String s = randomString ("");
                if ((index.getItems (s) == null) || (index.getItems (s).isEmpty ())) {
                    index.add (s, s);                    
                    for (int y = 0; y < PREFIXES_NUM; y++) {
                        if (s.startsWith (prefixes [y]))
                            counts [y]++;
                    } // for
                }
            } // for
            for (int x = 0; x < PREFIXES_NUM; x++) {
                int num = random.nextInt (MAX_2);
                for (int y = 0; y < num; y++) {
                    String s = randomString (prefixes [x]);
                    if ((index.getItems (s) == null) || (index.getItems (s).isEmpty ())) {
                        index.add (s,s);
                        counts [x] ++;
                    }
                }
                if (random.nextBoolean () && ((index.getItems (prefixes[x]) == null) 
                    || (index.getItems (prefixes[x]).isEmpty ()))) {
                    index.add (prefixes[x], prefixes[x]);
                    counts [x] ++;
                }
            }
            
            
            for (int x = 0; x < PREFIXES_NUM; x++) {
                // query keys starting with the specified prefix ...
                Collection list = index.queryByKeyPrefix (prefixes [x], primaryIndex);
                if (counts [x] != list.size ()) {
                    fail("#" + x + ", " + prefixes [x] + ": found " 
                        +  list.size () + ", expected " + counts [x]);
                }
                for (Iterator iter = list.iterator (); iter.hasNext ();) {
                    Map.Entry entry = (Map.Entry) iter.next ();
                    Collection values = (Collection) entry.getValue ();
                    if (values.size () != 1) {
                        fail (values.size () + " != 1");
                    }
                    Object val = values.iterator ().next ();
                    if (!val.equals (entry.getKey ())) {
                        fail ();
                    }
                }  // for
            } // for            
            
            // should return an empty collection
            Collection list = index.queryByKeyPrefix ("000", primaryIndex);            
            if (list.size () != 0) {
                fail(list.size () + " != 0");
            }
            
            index.add (LAST_ELEMENT, LAST_ELEMENT);
            list = index.queryByKeyPrefix (LAST_ELEMENT, primaryIndex);            
            if (list.size () != 1) {
                fail(list.size () + " != 1");
            }
            
            storage.commitChanges ();            
        } catch (Exception e) {
            e.printStackTrace ();
            fail ();
        }
    }
    
    public String randomString (String prefix) {
        final int minLength = 10;
        final int maxLength = 20;
        return randomString (prefix, minLength, maxLength);
    }
    
    public String randomString (String prefix, int minLength, int maxLength) {        
        String res = "";
        int length = Math.max (minLength, random.nextInt (maxLength + 1));
        for (int x = prefix.length (); x <= length; x++) {
            res = res + (char) (random.nextInt ('z' - 'a' + 1) + 'a');
        }
        return prefix + res;
    }
    
    // ..........................................................................
    
    private class Resolver implements ObjectResolver {
        
        public Object resolve(String storageID, Object key) {
            System.out.println("resolve object called");
            return null;
        }
        
    }
    
}

