/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.test;

import java.io.*;
import java.util.*;
import java.net.*;

import junit.extensions.*;
import junit.framework.*;

import org.netbeans.api.mdr.*;
import org.openide.util.Lookup;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

/**
 * Multivalued index test case.
 */
public class MultivaluedIndexTest extends MDRTestCase {        
    
    // number of classes that are generated to test (Btree)ListIterator functionality
    private static final int MAX = 2000;
    
    private long counter = 0;
    private Random random = new Random (0);
        
    public MultivaluedIndexTest(String testName) {
        super (testName);
    }
    
    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite ());
    }
    
    public static Test suite () {
        TestSuite suite = new TestSuite ();
        suite.addTestSuite (MultivaluedIndexTest.class);
        
        TestSetup setup = new TestSetup (suite) {
            public void setUp () {
//                org.netbeans.mdr.handlers.BaseObjectHandler.setDefaultClassLoader (this.getClass ().getClassLoader ());
            }
            public void tearDown () {
            }
        };        
        return setup;        
    }

    public void test () {
        MofClass classC = null, classN = null, classP = null;
        MofException excF = null, excR = null;
        Iterator iter = modelPackage.getMofClass ().refAllOfType ().iterator ();
        while (iter.hasNext ()) {
            MofClass mofClass = (MofClass) iter.next ();
            String name = mofClass.getName ();
            if (name.equals ("Namespace"))
                classN = mofClass;
            if (name.equals ("Class"))
                classC = mofClass;
            if (name.equals ("Package"))
                classP = mofClass;
        }
        iter = modelPackage.getMofException ().refAllOfType ().iterator ();
        while (iter.hasNext ()) {
            MofException mofExc = (MofException) iter.next ();
            String name = mofExc.getName ();
            if (name.equals ("NameNotFound"))
                excF = mofExc;
            if (name.equals ("NameNotResolved"))
                excR = mofExc;
        }
        
        iter = classC.getContents ().iterator ();
        excF.setContainer (classP);
        iter.next ();
        excF.setContainer (classN);
        while (iter.hasNext ())
            iter.next ();
        
        try {
            iter = classC.getContents ().iterator ();
            excF.setContainer (classC);
            excF.setContainer (classN);
            iter.next ();
            // CME should be thrown by iter.next () ...
            fail ("ConcurrentModificationException has not been thrown.");
        } catch (ConcurrentModificationException e) {
        }
        
        iter = classC.getContents ().iterator ();
        while (iter.hasNext ())
            iter.next ();
        
        Contains assoc = modelPackage.getContains ();
        List list = (List) assoc.refQuery ("container", classC);        
        list = null;
        System.gc ();
        list = (List) assoc.refQuery ("container", classC);        
        
        ListIterator listIter = list.listIterator ();
        Object obj = listIter.next ();
        listIter.remove ();
        Object obj2 = listIter.next ();        
        listIter.add (obj);
        Object obj3 = listIter.next ();        
    }
    
    public void test2 () {
        try {
            repository.beginTrans (true);
            int x;        
            MofClass main = generateClass ();
            for (x = 0; x < MAX; x++)
                generateClass ().setContainer (main);
            Contains assoc = modelPackage.getContains ();
            List list = (List) assoc.refQuery ("container", main);
            ListIterator iter = list.listIterator ();
            
            repository.endTrans ();
            repository.beginTrans (true);
            
            // test adding to and removing from the start of the list
            for (x = 0; x < MAX/10; x++)
                iter.add (generateClass ());
            for (x = 0; x < MAX/10; x++) {
                iter.next ();
                iter.remove ();
            }
                
            repository.endTrans ();
            repository.beginTrans (true);
            
            iter = list.listIterator ();
            Random random = new Random ();
            int size = MAX;
            for (x = 0; x < MAX/2; x++)
                iter.next ();
            for (x = 0; x < 4*MAX; x++) {
                int opCode = random.nextInt (5);
                switch (opCode) {
                    case 0:
                        if (iter.hasNext ())
                            iter.next ();
                    break;
                    case 1:
                        if (iter.hasPrevious ())
                            iter.previous ();
                    break;
                    case 2:
                        if (iter.hasNext ()) {
                            iter.next ();
                            iter.remove ();
                            size--;
                        } else if (iter.hasPrevious ()) {
                            iter.previous ();
                            iter.remove ();
                            size--;
                        }                    
                    break;
                    case 3:
                        if (iter.hasNext ()) {
                            iter.next ();
                            iter.set (generateClass ());
                        } else if (iter.hasPrevious ()) {
                            iter.previous ();
                            iter.set (generateClass ());
                        }                    
                    break;
                    case 4:
                        iter.add (generateClass ());
                        size++;
                    break;
                } // switch
            } // for
            if (list.size () != size)
                fail ("Counted list size does not match a value returned by size () method.");
        } catch (Exception e) {
            e.printStackTrace ();
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
    }
    
    public void test3 () {
        try {
            repository.beginTrans (true);
            MofClass class_A = generateClass ();
            MofClass class_B = generateClass ();
            class_B.setContainer (class_A);
            for (int x = 0; x < 3; x++)
                generateClass ().setContainer (class_B);
            Contains assoc = modelPackage.getContains ();
            List list = (List) assoc.refQuery ("container", class_A);
            printListElements ((List) assoc.refQuery ("container", class_B));
            printListElements ((List) assoc.refQuery ("containedElement", class_B));
            Iterator iter = list.iterator ();
            iter.next ();
            iter.remove ();
            printListElements (list);
            printListElements ((List) assoc.refQuery ("container", class_B));
            printListElements ((List) assoc.refQuery ("containedElement", class_B));
            
            MofClass class_C = generateClass ();
            for (int x = 0; x < 100; x++)
                generateClass().setContainer(class_C);
            int index = -1;
            ListIterator liter = class_C.getContents().listIterator();
            for (int x = 0; x < 90; x++) {
                int val = random.nextInt (5);
                switch (val) {
                    case 0: 
                    case 1:
                        liter.add (generateClass());
                        index ++;
                        break;
                    case 2:
                    case 3:
                        liter.next ();
                        index ++;
                        break;
                    case 4:
                        if (index > 0) {
                            liter.previous ();
                            index--;
                        }
                } // switch
            } // for
            if (liter.nextIndex() != (index + 1))
                fail ();
            
        } catch (Exception e) {
            e.printStackTrace ();
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
    }
    
    public void test4 () {
        try {
            repository.beginTrans (true);
            MofClass class_A = generateClass ();
            MofClass class_B = generateClass ();
            MofClass class_C = generateClass ();
            class_B.setContainer (class_A);
            for (int x = 0; x < 3; x++)
                generateClass ().setContainer (class_B);
            class_C.setContainer (class_B);
            
            Contains assoc = modelPackage.getContains ();
            
            printListElements ((List) assoc.refQuery ("container", class_B));
            printListElements ((List) assoc.refQuery ("containedElement", class_B));
            
            class_B.refDelete ();                        
            
            /*
            Contains assoc = modelPackage.getContains ();
            List list = (List) assoc.refQuery ("container", class_B);
            printListElements (list);
            Iterator iter = list.iterator ();
            while (iter.hasNext ()) {
                System.out.println("size: " + list.size ());
                iter.next ();
                iter.remove ();
            }
            System.out.println("size: " + list.size ());
            printListElements ((List) assoc.refQuery ("container", class_B));
            System.out.println("-------");
            */
        } catch (Exception e) {
            System.out.println(e);
            e.printStackTrace ();
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
    }
            
    public void test5 () {
        ModelPackage pkg = (ModelPackage) createExtent(findMofPackage(modelPackage, "Model"), "Test");
        MofClassClass proxy = pkg.getMofClass ();
        // create random tree structure (in containment hierarchy) of instances of MofClass
        MofClass root = generateClass (proxy);
        int num = proxy.refAllOfClass ().size ();        
        generateTree (root, 4, proxy);
        deleteTree (root);
        if (proxy.refAllOfClass ().size () != 1)
            fail ();
        generateTree2 (root, 4, proxy);        
        deleteTree (root);
        if (proxy.refAllOfClass ().size () != 1)
            fail ();
    }
    
    private void generateTree (MofClass elem, int depth, MofClassClass proxy) {
        int sons = 1 + random.nextInt (7);
        for (int x = 0; x < sons; x++) {
            MofClass mofClass = generateClass (proxy);
            mofClass.setContainer (elem);
            if (depth > 0)
                generateTree (mofClass, depth - 1, proxy);
        }
    }
    
    private void generateTree2 (MofClass elem, int depth, MofClassClass proxy) {
        int sons = 4 + random.nextInt (5);
        ListIterator iter = elem.getContents ().listIterator ();
        for (int x = 0; x < sons; x++) {
            MofClass mofClass = generateClass (proxy); 
            iter.add (mofClass);
            if (depth > 0)
                generateTree (mofClass, depth - 1, proxy);
            if (random.nextBoolean()) {
                deleteTree (mofClass);
                iter.previous ();
                iter.remove ();
                mofClass.refDelete ();
            }
        }
    }
    
    private void deleteTree (MofClass node) {
        Collection subNodes = node.getContents();
        int size = subNodes.size();
        for (Iterator it = subNodes.iterator(); it.hasNext();) {
            MofClass subNode = (MofClass)it.next();            
            it.remove();
            deleteTree (subNode);
            subNode.refDelete();            
        }
    }
    
    private MofClass generateClass (MofClassClass proxy) {
        return proxy.createMofClass ("name" + counter++, "", true, true, true, VisibilityKindEnum.PUBLIC_VIS, true);
    }
    
    private MofClass generateClass () {
        MofClassClass proxy = modelPackage.getMofClass ();
        return proxy.createMofClass ("name" + counter++, "", true, true, true, VisibilityKindEnum.PUBLIC_VIS, true);
    }
        
    private void printListElements (List list) {
        /*
        Iterator iter = list.iterator ();
        System.out.println("list size: " + list.size () + " " + list.getClass ().getName ());
        while (iter.hasNext ()) {
            ModelElement element = (ModelElement) iter.next ();
            System.out.println((element != null ? element.getName () : "null") + " ");
        }
        System.out.println("");
         */
    }
    
}
