/*
 * TestListeners.java
 * NetBeans JUnit based test
 *
 * Created on 5. duben 2002, 17:00
 */

package org.netbeans.mdr.test;

import java.util.Iterator;
import java.util.Collection;

import junit.framework.*;

import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.NBMDRepositoryImpl;

import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.CreationFailedException;

import org.netbeans.api.mdr.events.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

/**
 *
 * @author mk97936
 */
public class MDRTestAssociationEvents extends MDREventsTestCase implements MDRChangeListener {
    
    private static final String PKG_NAME = "TEST_MOF";

    private EventsList eventsList = new EventsList();
    
    public MDRTestAssociationEvents(java.lang.String testName) {
        super(testName);
    }
    
    protected void setUp() {
        super.setUp();
        ((MDRChangeSource) repository).addListener(this);
    }
    
    protected void tearDown() {
        super.tearDown();
        ((MDRChangeSource) repository).removeListener(this);
    }
    
    // -------------------------------------------------------------------------
    
    public void testAddAssociation() {
        
        RefPackage testMOFPackage = createMOFExtent(PKG_NAME);

        EventsDataGenerator generator = new EventsDataGenerator(repository.getExtent(PKG_NAME));
        
        Collection allMOFAssociations = testMOFPackage.refAllAssociations();
        Iterator iterAssoc = allMOFAssociations.iterator();
        while (iterAssoc.hasNext()) {
            RefAssociation assocProxy = (RefAssociation) iterAssoc.next();
            Association metaAssoc = (Association) assocProxy.refMetaObject();
            eventsList.addPattern2(metaAssoc.getName(), EventsList._ADD | EventsList._CHANGED, System.currentTimeMillis());
            java.util.List ends = generator.generateAssociation(assocProxy, metaAssoc, null, false);
            // !@#$%^& wait until event arives
            for (int i = 0; i < 20; i++) {
                try { Thread.currentThread().sleep(100); } 
                    catch (InterruptedException ie) { }
            }
            if (ends != null) {
                assertTrue(eventsList.checkEvents(metaAssoc.getName(), EventsList._ADD | EventsList._CHANGED));
            }
            eventsList.clear();
        }
        
    }
    
    public void testRemoveAssociation() {              
        
        RefPackage testMOFPackage = createMOFExtent(PKG_NAME);

        EventsDataGenerator generator = new EventsDataGenerator(repository.getExtent(PKG_NAME));
        
        Collection allMOFAssociations = testMOFPackage.refAllAssociations();
        Iterator iterAssoc = allMOFAssociations.iterator();
        while (iterAssoc.hasNext()) {
            RefAssociation assocProxy = (RefAssociation) iterAssoc.next();
            Association metaAssoc = (Association) assocProxy.refMetaObject();
            eventsList.addPattern2(metaAssoc.getName(), EventsList._ADD | EventsList._CHANGED, System.currentTimeMillis());
            java.util.List ends = generator.generateAssociation(assocProxy, metaAssoc, null, false);
            // !@#$%^& wait until event arives
            for (int i = 0; i < 20; i++) {
                try { Thread.currentThread().sleep(100); }
                    catch (InterruptedException ie) { }
            }
            if (ends != null) {
                assertTrue(eventsList.checkEvents(metaAssoc.getName(), EventsList._ADD | EventsList._CHANGED));
            }
            eventsList.clear();
            
            if (ends != null) {
                Collection links = assocProxy.refAllLinks();
                Object [] linksArray = links.toArray();
                if (linksArray.length >= 1) {
                    RefAssociationLink link = (RefAssociationLink) linksArray[0];
                    eventsList.addPattern2(metaAssoc.getName(), EventsList._REMOVE | EventsList._CHANGED, System.currentTimeMillis());
                    assocProxy.refRemoveLink(link.refFirstEnd(), link.refSecondEnd());
                    // !@#$%^& wait until event arives
                    for (int i = 0; i < 20; i++) {
                        try { Thread.currentThread().sleep(100); }
                            catch (InterruptedException ie) { }
                    }
                    assertTrue(eventsList.checkEvents(metaAssoc.getName(), EventsList._REMOVE | EventsList._CHANGED));
                    eventsList.clear();
                } else {
                    fail("Association contained no link!");
                }
            }
        }
        
    }
    
    // -------------------------------------------------------------------------
    
    public void change(MDRChangeEvent e) {        
        processEvent(e, CHANGED);
    }
    
    private void processEvent(MDRChangeEvent e, int type) {
        
        if (e.isOfType(AssociationEvent.EVENTMASK_ASSOCIATION)) { // AssociationEvent
            
            // EVENT_ASSOCIATION_ADD
            if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_ADD) && (type == PLANNED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AssociationEvent) e).getSource()).refMetaObject()).getName(), 
                                    e, System.currentTimeMillis(), EventsList._ADD | EventsList._PLANNED);
            } else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_ADD) && (type == CHANGED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AssociationEvent) e).getSource()).refMetaObject()).getName(), 
                                    e, System.currentTimeMillis(), EventsList._ADD | EventsList._CHANGED);
            } else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_ADD) && (type == CANCELED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AssociationEvent) e).getSource()).refMetaObject()).getName(), 
                                    e, System.currentTimeMillis(), EventsList._ADD | EventsList._CANCELED);
            }
            // EVENT_ASSOCIATION_SET
            else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_SET) && (type == PLANNED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AssociationEvent) e).getSource()).refMetaObject()).getName(), 
                                    e, System.currentTimeMillis(), EventsList._SET | EventsList._PLANNED);
            } else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_SET) && (type == CHANGED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AssociationEvent) e).getSource()).refMetaObject()).getName(), 
                                    e, System.currentTimeMillis(), EventsList._SET | EventsList._CHANGED);
            } else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_SET) && (type == CANCELED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AssociationEvent) e).getSource()).refMetaObject()).getName(), 
                                    e, System.currentTimeMillis(), EventsList._SET | EventsList._CANCELED);
            }
            // EVENT_ASSOCIATION_REMOVE
            else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_REMOVE) && (type == PLANNED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AssociationEvent) e).getSource()).refMetaObject()).getName(), 
                                    e, System.currentTimeMillis(), EventsList._REMOVE | EventsList._PLANNED);
            } else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_REMOVE) && (type == CHANGED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AssociationEvent) e).getSource()).refMetaObject()).getName(), 
                                    e, System.currentTimeMillis(), EventsList._REMOVE | EventsList._CHANGED);
            } else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_REMOVE) && (type == CANCELED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AssociationEvent) e).getSource()).refMetaObject()).getName(), 
                                    e, System.currentTimeMillis(), EventsList._REMOVE | EventsList._CANCELED);
            }
            
        }
        
    }
    
}
