/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.test;

import java.io.*;
import java.util.*;
import java.net.*;

import junit.extensions.*;
import junit.framework.*;

import org.netbeans.api.mdr.*;
import org.openide.util.Lookup;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.*;

import org.xml.sax.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;
import javax.jmi.xmi.*;

/**
 * Test case verifying functionality of XmiReader and XmiWriter.
 */
public class MDRExportImportTest extends MDRTestCase {
        
    public MDRExportImportTest (String testName) {
        super (testName);
    }
    
    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite ());
    }
    
    public static Test suite () {
        TestSuite suite = new TestSuite ();
        suite.addTestSuite (MDRExportImportTest.class);
        
        TestSetup setup = new TestSetup (suite) {
            public void setUp () {
            }
            public void tearDown () {
            }
        };        
        return setup;        
    }

    // **************************************************************************
    
    public void test () {
        RefPackage pkg = instantiateModel ("Java.xml", "Core", "Core");
        new RandomDataGenerator ().generate (pkg, 0, 5);
        
        Lookup lookup = Lookup.getDefault ();
        XmiReader reader = (XmiReader) lookup.lookup (XmiReader.class);
        XmiWriter writer = (XmiWriter) lookup.lookup (XmiWriter.class);
        
        File file = getFile ("temp.xml");
        try {
            OutputStream os = new FileOutputStream (file);
            repository.beginTrans (true);
            writer.write (os, pkg, null);
            os.flush ();
            os.close ();
        } catch (Exception e) {
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }        
        try {
            repository.beginTrans (true);
            reader.read (file.toURL ().toExternalForm(), pkg);            
        } catch (Exception e) {            
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
        deleteModel (pkg);
    }
    
    /**
     * Creates instance of Model package, loads Text metamodel into it, exports the loaded
     * data and compares the created XMI file to the original one.
     */
    public void testTextModel () {
        readWrite ("Text.xml");
    }        

    public void testCollectionType () {
        RefPackage pkg = instantiateModel ("Coll.xml", "Main", "Collections_test");        
        RefPackage pkg2 = instantiateModel ("Coll.xml", "Main", "Collections_test_2");        
        new RandomDataGenerator ().generate (pkg, 0, 5);
        
        org.netbeans.api.xmi.XMIWriter writer = 
            org.netbeans.api.xmi.XMIWriterFactory.getDefault ().createXMIWriter ();
        org.netbeans.api.xmi.XMIReader reader = 
            org.netbeans.api.xmi.XMIReaderFactory.getDefault ().createXMIReader ();

        File file_1 = getFile ("out.xml");
        File file_2 = getFile ("out_2.xml");
         
        try {
            repository.beginTrans (false);
            OutputStream os = new FileOutputStream (file_1);
            writer.write (os, pkg, null);
        } catch (Exception e) {            
            System.out.println(e);
            e.printStackTrace ();
        } finally {
            repository.endTrans (false);
        }
        
        boolean failed = true;
        try {
            repository.beginTrans (true);
            reader.read (file_1.toURL ().toExternalForm(), pkg2);
            failed = false;
        } catch (Exception e) {
            fail (e.getMessage ());
        } finally {
            repository.endTrans (failed);
        }
        
        try {
            repository.beginTrans (false);
            OutputStream os = new FileOutputStream (file_2);
            writer.write (os, pkg2, null);
        } catch (Exception e) {            
            fail (e.getMessage ());
        } finally {
            repository.endTrans (false);
        }
        
        deleteModel (pkg);
        deleteModel (pkg2);
    }
    
    public void testCollectionWritting () {
        RefPackage pkg = instantiateModel ("Text.xml", "Text", "text_1");
        RefPackage pkg2 = instantiateModel ("Text.xml", "Text", "text_2");
        new RandomDataGenerator ().generate (pkg, 0, 10);
        
        Lookup lookup = Lookup.getDefault ();
        XmiReader reader = (XmiReader) lookup.lookup (XmiReader.class);
        XmiWriter writer = (XmiWriter) lookup.lookup (XmiWriter.class);
        
        RefClass proxyWord = pkg.refClass ("Word");
        RefClass proxySentence = pkg.refClass ("Sentence");
        int sentenceSize = proxySentence.refAllOfType ().size ();
        int wordSize = proxyWord.refAllOfType ().size ();        
        List list = new LinkedList ();
        
        int wordCount = 0, sentenceCount = 0;
        Iterator iter = proxySentence.refAllOfType ().iterator ();
        for (int x = 0; x < sentenceSize; x++) {
            if (x > x / 3) {
                list.add (iter.next ());
                sentenceCount++;
            }
        }
        iter = proxyWord.refAllOfType ().iterator ();
        for (int x = 0; x < wordSize; x++) {
            if (x > x / 4) {
                list.add (iter.next ());
                wordCount++;
            }
        }
        
        File file = getFile ("temp.xml");
        try {
            OutputStream os = new FileOutputStream (file);
            repository.beginTrans (true);
            writer.write (os, list, null);
            os.flush ();
            os.close ();
        } catch (Exception e) {
            e.printStackTrace ();
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }        
        try {
            repository.beginTrans (true);
            reader.read (file.toURL ().toExternalForm(), pkg2);
        } catch (Exception e) {            
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
        
        // check number of deserialized instances        
        if (pkg2.refClass ("Sentence").refAllOfType().size() != sentenceCount)
            fail ("Number of deserialized Classes does not match.");
        if (pkg2.refClass ("Word").refAllOfType().size() != wordCount)
            fail ("Number of deserialized Methods does not match.");
        
        deleteModel (pkg);
        deleteModel (pkg2);
    }
    
    // **************************************************************************
    
    /**
     * Compares instances counts in packages, fails if there is a proxy with different number
     * of instantiated objects in each package.
     */
    private void compareData (RefPackage pkg_1, RefPackage pkg_2, Set checkedPackages) {
        Set set = new HashSet ();
        checkedPackages.add (pkg_1);
        Iterator iter = pkg_1.refAllClasses ().iterator ();
        while (iter.hasNext ()) {
            RefClass proxy = (RefClass) iter.next ();
            ModelElement meta = (ModelElement) proxy.refMetaObject ();
            int count = proxy.refAllOfType ().size ();
            int count2 = pkg_2.refClass (meta).refAllOfType ().size ();
            if (count != count2)
                fail ("Number of instances does not match: " + meta.getName () + " " + count + " " + count2);
        }
        iter = pkg_1.refAllAssociations ().iterator ();
        while (iter.hasNext ()) {
            RefAssociation proxy = (RefAssociation) iter.next ();
            ModelElement meta = (ModelElement) proxy.refMetaObject ();
            int count = proxy.refAllLinks ().size ();
            int count2 = pkg_2.refAssociation (meta).refAllLinks ().size ();
            if (count != count2)
                fail ("Number of links does not match: " + meta.getName () + " " + count + " " + count2);
        }
        iter = pkg_1.refAllPackages ().iterator ();
        while (iter.hasNext ()) {
            RefPackage p1 = (RefPackage) iter.next ();
            ModelElement meta = (ModelElement) p1.refMetaObject ();
            RefPackage p2 = pkg_2.refPackage (meta);
            compareData (p1, p2, checkedPackages);
        }
    }
    
    /**
     * Creates instance of Model package, loads a metamodel into it, exports the loaded
     * data and compares the created XMI file to the original one.
     *
     * @param name of an XMI documnet, it is assumend the document is placed in data
     * sub-folder
     */
    public void readWrite (String docName) {
        Lookup lookup = Lookup.getDefault ();
        XmiReader reader = (XmiReader) lookup.lookup (XmiReader.class);
        XmiWriter writer = (XmiWriter) lookup.lookup (XmiWriter.class);
        URL url = this.getClass ().getResource ("data" + File.separator + docName);
        if (url == null)
            fail ("Resource not found.");
        RefPackage pkg = createExtent (
            findMofPackage (modelPackage, "Model"), "PureMOF_test" + docName
        );
        try {
            repository.beginTrans (true);
            reader.read (url.toExternalForm(), pkg);
        } catch (Exception e) {                        
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
        File file = getFile ("temp.xml");
        try {
            OutputStream os = new FileOutputStream (file);
            repository.beginTrans (true);
            writer.write (os, pkg, null);
            os.flush ();
            os.close ();
        } catch (Exception e) {
            e.printStackTrace ();
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
        XMIComparator comp = new XMIComparator ();
        InputSource is = new InputSource (url.toString ());
        InputSource stream = null;
        try {
            stream = new InputSource (new FileInputStream (file));
        } catch (Exception e) {
            fail (e.getMessage ());
        }
        String result = comp.compareDocuments (is, stream);
        if (result != null)
            fail (result);
        assertTrue (true);
        try {
            pkg.refDelete ();
        } catch (Exception e) { // [PENDING]
        }
    }
    
    private RefPackage instantiateModel (String docName, String mainPackageName, String extentName) {        
        ModelPackage pkg = loadMOFModel (docName, extentName + "_meta");
        RefPackage result = createExtent (
            findMofPackage (pkg, mainPackageName),
            extentName
        );        
        return result;
    }
    
    private void deleteModel (RefPackage pkg) {
        RefPackage meta = null;
        try {
            if (pkg.refMetaObject () != null)
                meta = pkg.refMetaObject ().refOutermostPackage ();
        } catch (javax.jmi.reflect.InvalidObjectException e) {
        }
        try {
            pkg.refDelete ();
        } catch (Exception e) {
        }
        try {
            if (meta != null)
                meta.refDelete ();
        } catch (Exception e) {
        }
    }
}
