/*
 * MDRListener.java
 *
 * Created on 8. duben 2002, 10:55
 */

package org.netbeans.mdr.test;

import org.netbeans.api.mdr.events.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

//import java.io.PrintWriter;
//import java.io.PrintStream;


/**
 *
 * @author  mk97936
 */
public class MDRAttributeListener implements MDRChangeListener {
    
    // "type" of event
    public static final int PLANNED = 0;
    public static final int CHANGED = 1;
    public static final int CANCELED = 2;
    
    //private PrintStream goldenRef = null;
    private EventsList eventsList;
        
    /** Creates a new instance of MDRListener */
    public MDRAttributeListener() {        
    }
    
    public void setRef(EventsList el) {
        eventsList = el;
    }

    public void change(MDRChangeEvent e) {
        processEvent(e, CHANGED);
    }

    private void processEvent(MDRChangeEvent e, int type) {
        
       if (e.isOfType(AttributeEvent.EVENTMASK_ATTRIBUTE) || // AttributeEvent
                   e.isOfType(AttributeEvent.EVENTMASK_CLASSATTR)) {
            
            // EVENT_ATTRIBUTE_ADD
            if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_ADD) && (type == PLANNED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._ADD | EventsList._PLANNED);
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_ADD) && (type == CHANGED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._ADD | EventsList._CHANGED);
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_ADD) && (type == CANCELED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._ADD | EventsList._CANCELED);
            } 
            // EVENT_ATTRIBUTE_SET
            else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_SET) && (type == PLANNED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._SET | EventsList._PLANNED);
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_SET) && (type == CHANGED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._SET | EventsList._CHANGED);
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_SET) && (type == CANCELED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._SET | EventsList._CANCELED);
            } 
            // EVENT_ATTRIBUTE_REMOVE
            else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_REMOVE) && (type == PLANNED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._REMOVE | EventsList._PLANNED);
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_REMOVE) && (type == CHANGED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._REMOVE | EventsList._CHANGED);
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_REMOVE) && (type == CANCELED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._REMOVE | EventsList._CANCELED);
            }
                       
        }
        
    }
    
}
