/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.test;

import java.util.*;
import junit.framework.*;

import org.netbeans.api.mdr.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

/**
 *
 * @author  Dusan Balek
 */
public class InterceptionTest extends MDRTestCase {
    
    private static final String MODEL_XMI = "component.xml";
    private static final String MODEL_PKG_NAME = "InterceptionTest";
    private static final String PKG_ELEMENT = "Test";
    private static final String PKG_NAME = "InterceptionExtent";
    
    public static short componentPreSet = 0;
    public static short componentPostSet = 0;
    public static boolean componentPreSetVersion = false;
    public static short servicePreSet = 0;
    public static short servicePostSet = 0;
    public static boolean providesPreAdd = false;
    public static boolean providesPostAdd = false;
    
    /** Creates a new instance of InterceptionTest */
    public InterceptionTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(InterceptionTest.class);
    }
    
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public void test() {
        // Init
        ModelPackage pkg = this.loadMOFModel(MODEL_XMI, MODEL_PKG_NAME);
        // Create extent
        test.TestPackage testPkg = (test.TestPackage) createExtent(findMofPackage(pkg, PKG_ELEMENT), PKG_NAME);
        if (testPkg == null)
            fail("Extent creation failed.");

        test.ComponentClass cClass = testPkg.getComponent();
        test.Component comp = cClass.createComponent("A", 1);

        if (comp == null)
            fail("Object creation failed.");
        
        test.Component testComp = cClass.createComponent("A", 2);
        if (testComp != null)
            fail("Component creation interception failed.");    
        
        ArrayList list = new ArrayList(2);
        list.add("A");
        list.add(new Integer(3));
        testComp = (test.Component)cClass.refCreateInstance(list);
        if (testComp != null)
            fail("Component creation interception failed.");

        list = new ArrayList(2);
        list.add("A");
        try {
            cClass.refCreateInstance(list);
        } catch (WrongSizeException tme) {
            System.out.println("---> WrongSizeException is OK !!!");
        }
        list.add("B");
        try {
            cClass.refCreateInstance(list);
        } catch (TypeMismatchException tme) {
            System.out.println("---> TypeMismatchException is OK !!!");
        }
        

        // Attribute test
        comp.setName("X");
        if (! comp.getName().equals("X"))
            fail("Invalid attribute value");
        comp.setName("TestObjectInterceptor");
        if (! comp.getName().equals("X"))
            fail("Setting component attribute interception failed.");
        comp.refSetValue("name", "TestObjectInterceptor");
        if (! comp.getName().equals("X"))
            fail("Setting component attribute via reflective interface interception failed.");

        // Association test
        test.ServiceClass sClass = testPkg.getService();
        test.Service serv = sClass.createService("TestAssociationInterceptor");
        testPkg.getProvides().add(serv, comp);
        Collection c = comp.getProvidedService();
        if (c.size() != 0)
            fail("Association interceptor failed (C->S)");
        c = serv.getProvider();
        if (c.size() != 0)
            fail("Association interceptor failed (S->C)");
        testPkg.getProvides().refAddLink(serv, comp);
        c = comp.getProvidedService();
        if (c.size() != 0)
            fail("Association reflactive interceptor failed (C->S)");
        c = serv.getProvider();
        if (c.size() != 0)
            fail("Association reflective interceptor failed (S->C)");
        comp.getProvidedService().add(serv);
        c = comp.getProvidedService();
        if (c.size() != 1)
            fail("Adding association failed (C->S)");
        c = serv.getProvider();
        if (c.size() != 1)
            fail("Adding association failed (S->C)");
        
    }
}
