/*
 * EventsList.java
 *
 * Created on August 2, 2002, 4:33 PM
 */

package org.netbeans.mdr.test;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.api.mdr.events.MDRChangeEvent;

/**
 *
 * @author  mk97936
 */
public class EventsList {        
    
    public static final int _PLANNED = 128;
    public static final int _CHANGED = 256;
    public static final int _CANCELED = 512;
    
    public static final int _CREATE = 1024;
    public static final int _DELETE = 2048;
    public static final int _SET = 4096;
    public static final int _ADD = 8192;
    public static final int _REMOVE = 16384;
    
    private HashMap eventsMap = new HashMap();
    private LinkedList patternList = new LinkedList();
    
    /** Creates a new instance of EventsList */
    public EventsList() {
    }
    
    public boolean checkPreEvents() {
        return true;
    }
    
    public boolean checkEvents(String ptrn, int states) {
        
        boolean changedFound = false;
        boolean plannedFound = false;
        boolean canceledFound = false;
        Iterator iter = patternList.iterator();                
        
        //System.out.println("---> Searched pattern: " + ptrn);
        while (iter.hasNext()) {
            
            PatternProps pp = (PatternProps) iter.next();            
            //System.out.println("------> Saved pattern: " + pp.pattern + ", " + pp.timeStamp);
            
            Iterator eventsIter = eventsMap.values().iterator();
            //System.out.println("---------> Number of saved events: " + eventsMap.size());
            while (eventsIter.hasNext()) {
                
                EventProps eprop = (EventProps) eventsIter.next();
               
                if (ptrn != null) {
                    if (ptrn.equals(eprop.plannedPattern) && (_PLANNED == (_PLANNED & states)) &&
                        (pp.timeStamp <= eprop.plannedTimestamp)) {
                        //System.out.println("------------> Planned event: " + eprop.plannedPattern + ", " + eprop.plannedTimestamp);
                        plannedFound = true;
                    }
                    if (ptrn.equals(eprop.changedPattern) && (_CHANGED == (_CHANGED & states)) &&
                        (pp.timeStamp <= eprop.changedTimestamp)) {
                        //System.out.println("------------> Changed event: " + eprop.changedPattern + ", " + eprop.changedTimestamp);
                        changedFound = true;
                    }
                    if (ptrn.equals(eprop.canceledPattern) && (_CANCELED == (_CANCELED & states)) &&
                        (pp.timeStamp <= eprop.canceledTimestamp)) {
                        //System.out.println("------------> Canceled event: " + eprop.canceledPattern + ", " + eprop.canceledTimestamp);
                        canceledFound = true;
                    }
                } else { // ptrn == null => delete event
                    
                }
            }
        }
        
        if (changedFound && (_CHANGED == (_CHANGED & states))) return true;
            else if (plannedFound && (_PLANNED == (_PLANNED & states))) return true;
            else if (plannedFound && (_CANCELED == (_CANCELED & states))) return true;
            else return false;
        
    }
    
    public void addPattern(String ptrn, long ts) {
        PatternProps pp = new PatternProps(ptrn, ts);
        patternList.add(pp);
    }
    
    public void addPattern2(String ptrn, int states, long ts) {
        
        //System.out.println("adding pattern: " + ptrn + "; " + states + "; " + ts);
        
        PatternProps pp = new PatternProps(ptrn, ts, states);
        patternList.add(pp);
    }
    
    public void addEvent(String pattern, MDRChangeEvent evnt, long ts, int stats) {
        
        //System.out.println("adding event: " + pattern + "; " + evnt + "; " + ts + "; " + stats );
        
        if (!eventsMap.containsKey(evnt)) {
            EventProps ep = new EventProps(pattern, ts, stats);
            eventsMap.put(evnt, ep);
        } else {
            EventProps ep = (EventProps) eventsMap.get(evnt);
            if (_PLANNED == (stats & _PLANNED)) {
                ep.setPlanned(pattern, ts);
            } else if (_CHANGED == (stats & _CHANGED)) {
                ep.setChanged(pattern, ts);
            } else if (_CANCELED == (stats & _CANCELED)) {
                ep.setCanceled(pattern, ts);
            }
        }
        
    }
    
    public void clear() {
        eventsMap.clear();
        patternList.clear();
    }
    
    private class EventProps {
        
        public String plannedPattern = "";
        public String canceledPattern = "";
        public String changedPattern = "";
        
        public long plannedTimestamp = 0L;
        public long canceledTimestamp = 0L;
        public long changedTimestamp = 0L;
        
        public EventProps(String ptr, long tsmp, int stats) {
            
            if (_CHANGED == (stats & _CHANGED)) {
                changedPattern = ptr;
                changedTimestamp = tsmp;
            } else if (_PLANNED == (stats & _PLANNED)) {
                plannedPattern = ptr;
                plannedTimestamp = tsmp;
            } else if (_CANCELED == (stats & _CANCELED)) {
                canceledPattern = ptr;
                canceledTimestamp = tsmp;
            }
        }
        
        public void setChanged(String ptr, long tsmp) {
            changedPattern = ptr;
            changedTimestamp = tsmp;
        }
        
        public void setPlanned(String ptr, long tsmp) {
            plannedPattern = ptr;
            plannedTimestamp = tsmp;
        }
        
        public void setCanceled(String ptr, long tsmp) {
            canceledPattern = ptr;
            canceledTimestamp = tsmp;
        }
        
    }
    
    private class PatternProps {
        
        public String pattern;
        public long timeStamp;
        public int states;
        
        public PatternProps(String ptr, long ts) {
            pattern = ptr;
            timeStamp = ts;
            states = 0;
        }
        
        public PatternProps(String ptr, long ts, int st) {
            pattern = ptr;
            timeStamp = ts;
            states = st;
        }
        
    }
    
}
