/*
 * MDRDataGenerator.java
 *
 * Created on April 9, 2002, 10:37 AM
 */

package org.netbeans.mdr.test;

import javax.jmi.model.*;
import javax.jmi.reflect.*;

import java.util.Iterator;
import java.util.List;
import java.util.LinkedList;

import java.io.PrintStream;

import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.util.*;

/**
 *
 * @author  mk97936
 */
public class EventsDataGenerator extends RandomDataGenerator {
    
    private RefPackage extent;
    
    /** Creates a new instance of MDRDataGenerator */
    public EventsDataGenerator(RefPackage pkg) {
        super(pkg);
        extent = pkg;
    }
    
    public List generateAssociation(RefAssociation assocProxy, Association assoc, PrintStream ps, boolean planned) {
        //System.out.println("Association name: " + assoc.getName());
        LinkedList ends = new LinkedList();
        
        Iterator iterCont = ((Namespace) assoc).getContents().iterator();
        while (iterCont.hasNext()) {
            RefObject refObj = (RefObject) iterCont.next();
            if (refObj instanceof AssociationEnd) {
                MofClass mofClass = (MofClass) ((AssociationEnd) refObj).getType();
                if (mofClass.isAbstract()) {
                    mofClass = findSubtype(mofClass);
                }
                ends.add(mofClass);
            }
        }
        
        if (assocProxy instanceof Contains) {
            Namespace nmspc = (Namespace) generateInstance((MofClass) ends.get(0));
            ModelElement mdlelm = (ModelElement) generateInstance((MofClass) ends.get(1));
            
            assocProxy.refAddLink(nmspc, mdlelm);
            
            Iterator nmIter = nmspc.getContents().iterator();
            while (nmIter.hasNext()) {
                RefObject obj = (RefObject) nmIter.next();
                if (obj instanceof Reference) {
                    System.out.println(((Reference) obj).getReferencedEnd());
                }
            }
            
            return ends;            
            
        } else if (assocProxy instanceof Constrains) {
            assocProxy.refAddLink((Constraint) generateInstance((MofClass) ends.get(0)),
                (ModelElement) generateInstance((MofClass) ends.get(1)));
            return ends;
        } else if (assocProxy instanceof Aliases) {
            assocProxy.refAddLink((Import) generateInstance((MofClass) ends.get(0)),
                (Namespace) generateInstance((MofClass) ends.get(1)));
            return ends;
        } else if (assocProxy instanceof Generalizes) {
            assocProxy.refAddLink((GeneralizableElement) generateInstance((MofClass) ends.get(0)),
                (GeneralizableElement) generateInstance((MofClass) ends.get(1)));
            return ends;
        } else if (assocProxy instanceof AttachesTo) {
            assocProxy.refAddLink((ModelElement) generateInstance((MofClass) ends.get(0)),
                (Tag) generateInstance((MofClass) ends.get(1)));
            return ends;
        } else if (assocProxy instanceof CanRaise) {
            assocProxy.refAddLink((Operation) generateInstance((MofClass) ends.get(0)),
                (MofException) generateInstance((MofClass) ends.get(1)));
            return ends;
        } else if (assocProxy instanceof IsOfType) {
            assocProxy.refAddLink((Classifier) generateInstance((MofClass) ends.get(0)),
                (TypedElement) generateInstance((MofClass) ends.get(1)));
            return ends;
        }
        
        /*else if (assocProxy instanceof RefersTo) {
            System.out.println("-----> Creating RefersTo");
            assocProxy.refAddLink((Reference) generateInstance((MofClass) ends.get(0)),
                                  (AssociationEnd) generateInstance((MofClass) ends.get(1)));
        }*/
        
        // Derived associations DependsOn and Exposes cannot be created !!!
        
        return null;
        
    }        
    
    /**
     *
     *
     */
    public boolean setAttribute(RefObject refObj, PrintStream ps, boolean planned) {        
        boolean setAttr = false;
        Iterator contents = ((Namespace) refObj.refMetaObject()).getContents().iterator();
        while (contents.hasNext()) {
            Object contObj = contents.next();
            if (contObj instanceof Attribute) {
                Object attr = generateAttributeValue((Attribute) contObj);
                if ( ((Attribute) contObj).isChangeable() && ((Attribute) contObj).getMultiplicity().getUpper() == 1 ) {
                    //System.out.println("Setting attribute: " + contObj.toString());
                    refObj.refSetValue((RefObject) contObj, attr);
                    setAttr = true;
                }
            }
        }
        return setAttr;
    }
    
    /**
     *
     *
     */
    public boolean addAttribute(RefObject refObj, boolean remove, PrintStream ps, boolean planned) {
        boolean ws = false;
        Iterator contents = ((Namespace) refObj.refMetaObject()).getContents().iterator();
        while (contents.hasNext()) {
            Object contObj = contents.next();
            if (contObj instanceof Attribute) {
                if ( ((Attribute) contObj).isChangeable() && ((Attribute) contObj).getMultiplicity().getUpper() == -1 ) {
                    //System.out.println(((ModelElement) contObj).getName());
                    Classifier type = ((Attribute) contObj).getType();
                    List attrValues = (List) refObj.refGetValue((RefObject) contObj);
                    for (int i = 0; i < 5; i++) {
                        Object val = generateValue(type);
                        attrValues.add(val);
                        ws = true;
                    }
                    if (remove) {                        
                        for (int j = 0; j < 5; j++) {
                            attrValues.remove(0);
                        }
                    }
                }
            }
        }
        return ws;
    }

    public RefObject generateWrongInstance(MofClass mofClass) {
        RefPackage refPackage = (RefPackage) elementsCache.findProxy(mofClass);
        RefClass proxy = refPackage.refClass(mofClass);
        List args = new LinkedList();
        args.add(new java.util.Date());
        return proxy.refCreateInstance(args);
    }
    
}
