/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.test;

import java.io.*;
import java.util.*;
import java.net.*;

import junit.extensions.*;
import junit.framework.*;

import org.netbeans.api.mdr.DTDProducer;
import org.netbeans.api.xmi.*;
import org.netbeans.api.xmi.sax.*;
import org.openide.util.Lookup;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.*;

import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;
import javax.xml.parsers.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

/**
 * Test case verifying functionality of XmiReader and XmiWriter.
 */
public class DTDProducerTest extends MDRTestCase {
    
    public DTDProducerTest(String testName) {
        super (testName);
    }
    
    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite ());
    }
    
    public static Test suite () {
        TestSuite suite = new TestSuite ();
        suite.addTestSuite (DTDProducerTest.class);
        
        TestSetup setup = new TestSetup (suite) {
            public void setUp () {
            }
            public void tearDown () {
            }
        };        
        return setup;
    }
    
    // **************************************************************************
    
    public void test () {
        // doTest ("01-02-15_Diff.xml", "UML", "uml_inst");
        doTest ("Text.xml", "Text", "text_inst");
        doTest ("Java.xml", "Core", "java_inst");
    }
    
    public void doTest (String xmlName, String packageName, String fileName) {
        RefPackage pkg = instantiateModel (xmlName, packageName, packageName + "_1");
        new RandomDataGenerator ().generate (pkg, 0, 12);
        RefPackage pkg2 = instantiateModel (xmlName, packageName, packageName + "_2");
        
        Lookup lookup = Lookup.getDefault ();
        DTDProducer producer = DTDProducer.getDefault ();
        XMIWriter writer = XMIWriterFactory.getDefault ().createXMIWriter ();
        XMIReader reader = XMIReaderFactory.getDefault ().createXMIReader ();

        try {
            OutputStream os = new FileOutputStream (getFile(fileName + ".dtd"));
            producer.generate (os, pkg);
            os.flush ();
            os.close ();
        } catch (Exception e) {
            e.printStackTrace();
            fail (e.getMessage ());
        }

        File file_temp = getFile (fileName + ".temp");
        File file = getFile (fileName + ".xml");

        try {
            OutputStream os = new FileOutputStream (file_temp);
            repository.beginTrans (true);
            writer.write (os, fileName + ".temp", pkg, null);
            os.flush ();
            os.close ();
        } catch (Exception e) {
            e.printStackTrace();
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }        
        
        addDTDTag (file_temp, file, fileName + ".dtd");

        /*
        try {
            repository.beginTrans (true);
            reader.read (file.toURL ().toExternalForm(), pkg2);
        } catch (Exception e) {
            e.printStackTrace ();
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
         */
        
        Validator validator = new Validator ();
        validator.validate (file);
     
        deleteModel (pkg);
        deleteModel (pkg2);
    }
    
    private RefPackage instantiateModel (String docName, String mainPackageName, String extentName) {        
        ModelPackage pkg = loadMOFModel (docName, extentName + "_meta");
        RefPackage result = createExtent (
            findMofPackage (pkg, mainPackageName),
            extentName
        );        
        return result;
    }
    
    private void deleteModel (RefPackage pkg) {
        RefPackage meta = pkg.refMetaObject ().refOutermostPackage ();
        pkg.refDelete ();
        meta.refDelete ();
    }

    private void addDTDTag (File src, File dest, String dtdFileName) {
        try {
            InputStream in = new FileInputStream (src);
            BufferedReader reader = new BufferedReader (new InputStreamReader(in));
            PrintStream writer = new PrintStream (new FileOutputStream (dest));
            String line = reader.readLine ();
            writer.println (line);
            writer.println ("<!DOCTYPE XMI SYSTEM \"" + dtdFileName + "\">");
            line = reader.readLine ();
            while (line != null) {
                writer.println (line);
                line = reader.readLine();
            }
            writer.close ();
            writer.flush ();
        } catch (IOException e) {
            e.printStackTrace ();
            fail (e.getMessage ());
        }
    }

    // ..........................................................................

    private class Validator extends DefaultHandler {

        public void validate (File xmiFile) {
            try {
                InputSource input = new InputSource (new FileInputStream (xmiFile));
                input.setSystemId(xmiFile.toURL().toString());
                SAXParserFactory factory = SAXParserFactory.newInstance ();
                factory.setValidating (true);
                SAXParser saxParser = factory.newSAXParser ();
                saxParser.parse (input, this);
            } catch (Exception e) {
                e.printStackTrace ();
                fail (e.getMessage ());
            }
        }

    }

}
