/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.test;

import java.io.*;
import java.util.*;
import java.net.*;

import junit.extensions.*;
import junit.framework.*;

import org.netbeans.api.mdr.*;
import org.openide.util.Lookup;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.storagemodel.*;
import org.netbeans.mdr.handlers.*;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

import text.*;

/**
 * Multivalued index test case.
 */
public class AdditionalIndexTest extends MDRTestCase {
        
    private static final int KEY_COUNT = 3;
    private static final int MAX = 400;
    private static final String INDEX_NAME = "Indexik"; 
    
    public AdditionalIndexTest(String testName) {
        super (testName);
    }
    
    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite ());
    }
    
    public static Test suite () {
        TestSuite suite = new TestSuite ();
        suite.addTestSuite (AdditionalIndexTest.class);
        
        TestSetup setup = new TestSetup (suite) {
            public void setUp () {
            }
            public void tearDown () {
            }
        };        
        return setup;        
    }

    public void test_1 () {
        Iterator iter;
        int x, y, z;
        
        ModelPackage modelPackage = loadMOFModel ("IndexedModel.xml", "Text");
        TextPackage pkg = (TextPackage) createExtent (findMofPackage (modelPackage, "Text"), "test");
        
        Integer i1 = new Integer (10);
        Integer i2 = new Integer (222);
        Integer i3 = new Integer (3000);
        
        Sentence s1 = pkg.getSentence().createSentence();
        Sentence s2 = pkg.getSentence().createSentence();
        Object [][] keys = {{"a", "bb", "ccc"}, {i1, i2, i3}, {s1, s2, null}};
        int [][][] counts = new int [KEY_COUNT][KEY_COUNT][KEY_COUNT];
        
        for (x = 0; x < KEY_COUNT; x++) {
            for (y = 0; y < KEY_COUNT; y++) {
                for (z = 0; z < KEY_COUNT; z++) {
                    counts [x][y][z] = 0;
                } // for
            } // for
        } // for
        
        // generate instances
        WordClass proxy = pkg.getWord ();
        Word2Class proxy2 = pkg.getWord2 ();
        Random random = new Random (0);
        for (x = 0; x < MAX; x++) {
            boolean wordInstance = random.nextBoolean();
            int [] index = new int [KEY_COUNT]; 
            for (y = 0; y < KEY_COUNT; y++) {
                index [y] = random.nextInt (KEY_COUNT);                
            } // for
            counts[index[0]][index[1]][index[2]]++;
            List params = new LinkedList ();
            params.add (keys[0][index[0]]);
            params.add (keys[1][index[1]]);
            params.add (keys[1][index[1]]);
            if (wordInstance) {
                ((Word) proxy.refCreateInstance (params)).setSentence ((Sentence) keys[2][index[2]]);
            } else {
                params.add (keys[0][index[0]]);
                ((Word2) proxy2.refCreateInstance (params)).setSentence ((Sentence) keys[2][index[2]]);
            }
        } // for
        
        MdrStorage storage = ((BaseObjectHandler) proxy)._getDelegate().getMdrStorage ();
        
        for (x = 0; x < KEY_COUNT; x++) {
            for (y = 0; y < KEY_COUNT; y++) {
                for (z = 0; z < KEY_COUNT; z++) {
                    Map map = new HashMap ();
                    map.put ("color", keys[0][x]);
                    map.put ("number", keys[1][y]);
                    map.put ("sentence", keys[2][z]);
                    int size = storage.queryAdditionalIndex(((BaseObjectHandler)pkg)._getDelegate().getMofId(), INDEX_NAME, map).size();
                    if (size != counts[x][y][z]) {
                        System.out.println("Wrong result, indexes: " + x + " " + y + " " + z);
                        fail();
                    }
                } // for
            } // for
        } // for                
        
        pkg.refDelete ();
        modelPackage.refDelete ();
    }
    
    public void test_2 () {
        ModelPackage modelPackage = loadMOFModel ("IndexedModel.xml", "Text");
        TextPackage pkg = (TextPackage) createExtent (findMofPackage (modelPackage, "Text"), "test");        
        
        int x;
        int num = 'z' - 'a' + 1;
        Random random = new Random (0);
        int [] count = new int [num];
        Word [] word = new Word [MAX];
        
        for (x = 0; x < num; x++)
            count[x] = 0;
        
        WordClass proxy = pkg.getWord ();
        Word2Class proxy2 = pkg.getWord2 ();
        MdrStorage storage = ((BaseObjectHandler) proxy)._getDelegate().getMdrStorage ();
        
        for (x = 0; x < MAX; x++) {
            int n = random.nextInt (num);
            count[n]++;
            String s = "" + ((char) ('a' + n));
            if (random.nextBoolean())
                word [x] = proxy.createWord (s, 1, 2);
            else
                word [x] = proxy2.createWord2 (s, 1, 2, s);
        }
         
        for (x = 0; x < MAX * 4; x++) {
            int n = random.nextInt (num);
            int index = random.nextInt (MAX);
            int old = word[index].getColor().charAt (0) - 'a';
            count[old]--;
            word[index].setColor ("" + ((char) ('a' + n)));
            count[n]++;
        }
        
        for (x = 0; x < MAX / 3; x++) {
            int index = random.nextInt (MAX);
            if (word[index] != null) {
                int old = word[index].getColor().charAt (0) - 'a';
                count[old]--;
                word[index].refDelete();
                word[index] = null;
            }
        }
        
        for (x = 0; x < num; x++) {
            String s = "" + ((char) ('a' + x));
            int size = storage.getObjectsFromAdditionalIndex(((BaseObjectHandler)pkg)._getDelegate().getMofId(), "Indexik2", s).size();
            if (size != count[x]) {
                System.out.println("counts do not match: expected " + count[x] + ", found " + size);
                fail ();
            } // if
        } // for
        
        pkg.refDelete ();
        modelPackage.refDelete ();                
    }
    
    public void test_3 () {
        ModelPackage modelPackage = loadMOFModel ("IndexedModel.xml", "Text");
        TextPackage pkg = (TextPackage) createExtent (findMofPackage (modelPackage, "Text"), "test");
        
        Sentence s1 = pkg.getSentence().createSentence();
        Sentence s2 = pkg.getSentence().createSentence();
        
        // generate instances
        WordClass proxy = pkg.getWord ();
        Word2Class proxy2 = pkg.getWord2 ();
        
        proxy.createWord ("a", 1, 2).setSentence (s1);
        proxy.createWord ("b", 1, 2);
        Word w = proxy.createWord ("c", 1, 2);
        w.setSentence (s2);
        w.setSentence (s1);
        w.setSentence (s2);
        proxy.createWord ("a", 1, 2).setSentence (s1);
        proxy.createWord ("b", 1, 2).refDelete ();
        
        MdrStorage storage = ((BaseObjectHandler) proxy)._getDelegate().getMdrStorage ();
        int size;
        
        size = storage.getObjectsFromAdditionalIndex(((BaseObjectHandler)pkg)._getDelegate().getMofId(), "Indexik3", s1).size();
        if (size != 2)
            fail ("found: " + size);
                
        size = storage.getObjectsFromAdditionalIndex(((BaseObjectHandler)pkg)._getDelegate().getMofId(), "Indexik3", s2).size();
        if (size != 1)
            fail ("found: " + size);
                
        size = storage.getObjectsFromAdditionalIndex(((BaseObjectHandler)pkg)._getDelegate().getMofId(), "Indexik3", null).size();
        if (size != 1)
            fail ("found: " + size);
        
        pkg.refDelete ();
        modelPackage.refDelete ();
    }
    
    public void test_4 () {
        ModelPackage modelPackage = loadMOFModel ("IndexedModel.xml", "Text");
        TextPackage pkg = (TextPackage) createExtent (findMofPackage (modelPackage, "Text"), "test");
        
        WordClass proxy = pkg.getWord ();
        Word3Class proxy3 = pkg.getWord3 ();
        MdrStorage storage = ((BaseObjectHandler) proxy)._getDelegate().getMdrStorage ();
        
        Integer i1 = new Integer (10);
        Integer i2 = new Integer (222);
        Integer i3 = new Integer (3000);
        
        Sentence s1 = pkg.getSentence().createSentence();
        Sentence s2 = pkg.getSentence().createSentence();
        Sentence s3 = pkg.getSentence().createSentence();
                                
        Word v1 = proxy.createWord ("a", 1, 2);
        Word v2 = proxy.createWord ("a", 1, 3);
        Word v3 = proxy.createWord ("a", 1, 3);        
        
        List list_1 = new LinkedList ();
        list_1.add ("a"); list_1.add ("b"); list_1.add ("c");
        List list_2 = new LinkedList ();
        list_2.add ("b"); list_2.add ("a"); list_2.add ("c");
        List list_3 = new LinkedList ();
        list_3.add ("b"); list_3.add ("c"); list_3.add ("a");
        
        Word3 w1, w2, w3, w4, w5;
        w1 = proxy3.createWord3 ("a", 0, 0, "a", list_1, list_2);
        w2 = proxy3.createWord3 ("a", 0, 0, "a", list_2, null);
        w3 = proxy3.createWord3 ("a", 0, 0, "a", list_2, null);
        w4 = proxy3.createWord3 ("b", 0, 0, "a", null, null);
        w5 = proxy3.createWord3 ();
        
        w5.setColor ("blue");        
        Collection list = w5.getOrderedMulti ();
        System.out.println(list.getClass().getName());
        list.add ("a"); list.add ("b"); list.add ("c");
        list = w5.getUnorderedMulti ();
        list.add ("c"); list.add ("b"); list.add ("a");
        
        HashMap map = new HashMap ();
        map.put ("orderedMulti", list_1);
        map.put ("secondEnd", new LinkedList ());
        map.put ("unorderedMulti", list_3);
        
        int size = storage.queryAdditionalIndex(((BaseObjectHandler)pkg)._getDelegate().getMofId(), "Index", map).size();
        if (size != 2)
            fail ("found: " + size);
        
        list = w2.getRef ();
        list.add (v1); list.add (v2); list.add (v3);
        list = w3.getRef ();
        list.add (v2); list.add (v3); list.add (v1);
        list = w4.getRef ();
        list.add (v2); list.add (v3); list.add (v1);
        w4.refDelete ();
        ListIterator iter = w2.getOrderedMulti ().listIterator ();
        iter.next (); iter.remove (); iter.next (); iter.add ("d");
        iter = w3.getOrderedMulti ().listIterator ();
        iter.next (); iter.remove (); iter.next (); iter.add ("d");
        
        list_1.clear ();
        list_1.add ("a"); list_1.add ("d"); list_1.add ("c");
        list_2.clear ();
        list_2.add (v1); list_2.add (v2); list_2.add (v3);
        
        map.clear ();
        map.put ("orderedMulti", list_1);
        map.put ("secondEnd", list_2);
        map.put ("unorderedMulti", new LinkedList ());
        
        size = storage.queryAdditionalIndex(((BaseObjectHandler)pkg)._getDelegate().getMofId(), "Index", map).size();
        if (size != 2)
            fail ("found: " + size);
        
        pkg.refDelete ();
        modelPackage.refDelete ();        
    }
    
}
