/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.util;

import java.util.*;
import java.io.*;
import javax.jmi.reflect.*;

/**
 *
 * @author  Pavel Buzek
 * @version 
 */
public class XmlUtils extends Object {

    static byte buf[] = new byte[4096];

    public static String readTagStart (InputStream is) throws IOException {
        while (is.read() != '<');
        int c, i=0;
        while ( (c=is.read()) != '>') {
            buf[i++]=(byte)c; // must be ascii
        }
        String result = new String(buf, 0, i);
        return result;
    }

    public static String readValue (InputStream is) throws IOException {
        int c, i=0;
        while ( (c=is.read()) != '<') {
            buf[i++]=(byte)c; // must be ascii
        }
        return decode(new String(buf, 0, i));
    }

    public static String readComplexValue (InputStream is) throws IOException {
        String start = readTagStart(is);
        int c, i=0, left=0;
        for (;;) {
            while ( ((c=is.read()) != '>') ) {
                if (c=='<') left = i;
                buf[i++]=(byte)c; // must be ascii
            }
            try {
            if (start.equals(new String(buf, left+2, i-left-2))) break;
            } catch (StringIndexOutOfBoundsException e) {
                Logger.getDefault().annotate(e, new Integer(left + 2).toString());
                Logger.getDefault().annotate(e, new Integer(i - left - 2).toString());
                Logger.getDefault().annotate(e, new String(buf, 0, i));
                throw e;
            }
            buf[i++]=(byte)'>';
        }
            
        String value = new String(buf, 0, left);
//        Logger.getDefault().log("result:"+value);
        return value;
    }
    
    public static void skipTagEnd (InputStream is) throws IOException {
        while ( is.read() != '>'); // skip the </..end..>
    }

    public static String readTextTag (InputStream is) throws IOException {
        readTagStart(is);
        String value = readValue(is);
        skipTagEnd(is);
        return value;
    }

    public static String encode(String str) {
        StringBuffer sb = new StringBuffer(str.length());
        String c;

        for (int i = 0; i < str.length(); i++) {
            c = str.substring(i, i + 1);
            if (c.equals("&")) {
                sb.append("&amp;");
            } else if (c.equals("<")) {
                sb.append("&lt;");
            } else if (c.equals(">")) {
                sb.append("&gt;");
            } else if (c.equals("\"")) {
                sb.append("&quot;");
            } else if (c.equals("'")) {
                sb.append("&apos;");
            } else {
                sb.append(c);
            }
        }

/*        if (!sb.toString().equals(str)) {
            Logger.getDefault().log("coded: " + str + " -> " + sb);
        }
*/
        return sb.toString();
    }

    public static String decode(String str) {
        StringBuffer sb = new StringBuffer(str.length());
        String c;
        int i = 0;
        int j = -1;

        while ((i = str.indexOf("&", j)) >= 0) {
            sb.append(str.substring(j + 1, i));
            j = str.indexOf(";", i + 1);
            if (j > i + 1) {
                c = str.substring(i + 1, j);
                if (c.equals("amp")) {
                    sb.append("&");
                } else if (c.equals("lt")) {
                    sb.append("<");
                } else if (c.equals("gt")) {
                    sb.append(">");
                } else if (c.equals("quot")) {
                    sb.append("\"");
                } else if (c.equals("apos")) {
                    sb.append("'");
                } else {
                    Logger.getDefault().log(Logger.WARNING, "Error! Cannot substitute character: " + c);
                    return "";
                }
            } else {
                Logger.getDefault().log(Logger.WARNING, "Error! End of substitution not found.");
                return "";
            }
        }

        sb.append(str.substring(j + 1));

/*        if (!sb.toString().equals(str)) {
            Logger.getDefault().log("decoded: " + str + " -> " + sb);
        }
*/
        return sb.toString();
    }

    public static String encodeString(String text) {
        return "<textValue>" + encode(text) + "</textValue>";
    }
    
    public static String decodeString(InputStream inputStream) throws IOException {
        return readTextTag(inputStream); //value
    }
    
    public static String encodeList(List list) {
        StringBuffer buf = new StringBuffer(100);
        buf.append("<list>");
        for (Iterator it = list.iterator(); it.hasNext();) {
            buf.append(encodeString((String) it.next()));
        }
        buf.append("</list>");
        return buf.toString();
    }
    
    public static void decodeList(InputStream inputStream, List list) throws IOException {
        readTagStart(inputStream); //<list>
        for (;;) {
            String str = readTagStart(inputStream); //<value>
            if (str.equals("/list")) break; // </list>
            list.add(readValue(inputStream));
            skipTagEnd(inputStream); // </value>
        }
    }
}
