/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.util;

import java.util.*;
import javax.jmi.reflect.*;

import org.w3c.dom.*;

import org.netbeans.api.mdr.*;

import org.netbeans.lib.jmi.util.*;

/**
 * @author Marek Sedliak
 * @version 
 */
public abstract class XmiUtils {
    private static HashMap namespaces = new HashMap();
    
    static {
        namespaces.put("Model", "Model");
        namespaces.put("UML", "Model_Management");
        namespaces.put("CWMOLAP", "Olap");
        namespaces.put("CWMTFM", "Transformation");
        namespaces.put("CWM", "BusinessInformation");
        namespaces.put("CWMRDB", "Relational");
    }

    public static String getXmiAttrValueAsString(Node node, String attributeName) {
        String result = null;
        if (node != null) {
            result = getAttributeValueAsString( node, getShortName(attributeName));
            if (result == null) result = getElementValueAsString( node, attributeName );
        }
        return result;
    }
    
    public static List getXmiMultiValueAsString(Node node, String attributeName) {
        List result = null;
        if (node != null) {
            // assume the MultiValued thing cannot be as an attribute...
            return getElementValueAsStringList( node, attributeName );
        }
        return result;
    }

    public static List getXmiRefValue(Node node, String attributeName) {
        List value = new ArrayList();
        if (node != null) {
            String attr = getAttributeValueAsString(node, getShortName(attributeName));
            if (attr == null) {
                Node refNode = getChildNode(node, attributeName);
                if (refNode != null) {
                    NodeList values = refNode.getChildNodes();
                    for (int i = 0; i < values.getLength(); i++) {
                        if (isTextNode(values.item(i))) continue;
                        value.add(getAttributeValueAsString(values.item(i), XmiConstants.XMI_IDREF));
                    }
                }
            } else {
                // parse the string
                int pos;
                while ((pos = attr.indexOf(' ')) > -1) {
                    if (pos > 0) {
                        value.add(attr.substring(0, pos));
                    }
                    attr = attr.substring(pos + 1);
                }
                value.add(attr);
            }
        }
        return value;
    }
    
    public static String getAttributeValueAsString(Node node, String attributeName) {
        String result = null;
        if ( (node != null) && (node.hasAttributes()) ) {
            Node attribute = node.getAttributes().getNamedItem(attributeName);
            if (attribute != null) result = attribute.getNodeValue();
        }
        return result;
    }
    
    public static String getElementValueAsString(Node node, String attributeName) {
        String result = null;
        if (node != null) {
            Node attributeNode = getChildNode( node, attributeName );
            if (attributeNode != null) {
                attributeNode = attributeNode.getFirstChild();
                if (attributeNode == null) {
                    result = "";
                } else {
                    result = attributeNode.getNodeValue();
                }
            }
        }
        return result;
    }

    public static List getElementValueAsStringList(Node node, String attributeName) {
        List result = null;
        if (node != null) {
            List l = getChildNodeList( node, attributeName );
            if (l != null) {
                result = new ArrayList(l.size());
                for (Iterator it = l.iterator(); it.hasNext(); ) {
                    Node attributeNode = ((Node)it.next()).getFirstChild();
                    if (attributeNode == null) {
                        result.add("");
                    } else {
                        result.add(attributeNode.getNodeValue());
                    }
                }
            }
        }
        return result;
    }

    public static List getChildNodeList(Node parentNode, String childNodeName) {
        List result = null;
        if ((parentNode != null) && (childNodeName != null)) {
            NodeList children = parentNode.getChildNodes();
            for (int cnt = 0; cnt < children.getLength(); cnt++) {
                Node child = children.item(cnt);
                // [PENDING] this is ugly !!! namespaces should be resolved correctly
                if (childNodeName.equals(resolveFullName(child))) {
                    if (result == null)
                        result = new LinkedList();
                    result.add(child);
                }
            }
        }
        return result;
    }

    public static Node getChildNode(Node parentNode, String childNodeName) {
        Node result = null;
        if ((parentNode != null) && (childNodeName != null)) {
            NodeList children = parentNode.getChildNodes();
            for (int cnt = 0; cnt < children.getLength(); cnt++) {
                Node child = children.item(cnt);
                // [PENDING] this is ugly !!! namespaces should be resolved correctly
                if (childNodeName.equals(resolveFullName(child))) {
                    result = child;
                    break;
                }
            }
        }
        return result;
    }

    public static String resolveFullName(Node element) {
        if (isXmiNode(element)) return element.getNodeName();
        return resolveFullNameAsString( element.getNodeName() );
    }

    public static String resolveFullNameAsString(String fullName) {
        // [PENDING] here should be resolved by what should be the namespace name replaced
        // the following line works ok for MOF, because namespace Model represents package Model
//        Logger.getDefault().log("resolving full name: " + fullName);
        if (fullName != null) {
            int index;
            if ((index = fullName.indexOf(':')) > 0) {
//                Logger.getDefault().log(": found, the result is: " + namespaces.get(fullName.substring(0, index)) + "." + fullName.substring(index + 1));
                return namespaces.get(fullName.substring(0, index)) + "." + fullName.substring(index + 1);
            } else {
                return fullName;
            }
        }
        else
            return null;
    }

    public static String getShortName(String fullyQualifiedName) {
        String result = fullyQualifiedName;
        if ((fullyQualifiedName != null) && (fullyQualifiedName.toUpperCase(Locale.US).indexOf( XmiConstants.XMI_PREFIX ) > -1)) return fullyQualifiedName;
        if ((result != null) && (result.indexOf(XmiConstants.NS_SEPARATOR)>-1)) result = result.substring(result.indexOf(XmiConstants.NS_SEPARATOR)+1);
        if ((result != null) && (result.indexOf(XmiConstants.DOT_SEPARATOR)>-1)) result = result.substring(result.lastIndexOf(XmiConstants.DOT_SEPARATOR)+1);
        return result;
    }

    public static boolean isTextNode(Node node) {
        boolean result = false;
        if (node != null) result = (node.getNodeName().equals( XmiConstants.TEXT_NODE_NAME ) || node.getNodeName().equals( XmiConstants.COMMENT_NODE_NAME ));
        return result;
    }

    public static boolean isXmiNavigationNode(Node node) {
        boolean result = false;
        if (node != null) {
            result = (node.getNodeName().equals( XmiConstants.XMI_ID ) || result);
            result = (node.getNodeName().equals( XmiConstants.XMI_UUID ) || result);
            result = (node.getNodeName().equals( XmiConstants.XMI_LABEL ) || result);
            result = (node.getNodeName().equals( XmiConstants.XMI_IDREF ) || result);
        }
        return result;
    }
    
    public static boolean isXmiNode(Node node) {
        boolean result = false;
        if (node != null) {
            result |= isXmiNavigationNode(node);
            result |= node.getNodeName().equals(XmiConstants.XMI_ANY_TYPE);
        }
        return result;
    }

    public static class XmiNodeIterator {

        private Node node = null;
        private String attrName;
        private String attrValue;
        private String nodeName;

        private NodeList childNodes = null;
        private Node currentNode = null;
        private int index = 0;

        public XmiNodeIterator(Node node,String nodeName) {
            this.attrName = null;
            this.attrValue = null;
            this.nodeName= nodeName;
            this.node = node;
            this.childNodes = node.getChildNodes();
            findNext();
        }

        public XmiNodeIterator(Node node,String attrName,String attrValue) {
            this.attrName = attrName;
            this.attrValue = attrValue;
            this.nodeName = null;
            this.node = node;
            this.childNodes = node.getChildNodes();
            findNext();
        }

        public XmiNodeIterator(Node node) {
            this( node, null, null );
        }

        public boolean hasNext() {
            return currentNode != null;
        }

        public Node next() {
            Node result = currentNode;
            findNext();
            return result;
        }

        private void findNext() {

            for( int i = index; i < childNodes.getLength(); i++ ) {

                Node sn = childNodes.item( i );
                if ( isTextNode( sn ) ) continue;

                if ( attrName != null && (
                getXmiAttrValueAsString( sn, attrName ) == null ||
                !getXmiAttrValueAsString( sn, attrName ).equals( attrValue ) ) ) {
                    continue;
                }

                if ( nodeName != null && (!resolveFullName(sn).substring(nodeName.lastIndexOf('.') + 1).equals(nodeName.substring(nodeName.lastIndexOf('.') + 1)))) {
                    continue;
                }

                currentNode = sn;
                index = i + 1;
                return;
            }

            currentNode = null;
            index = childNodes.getLength();
        }
    }
}
