/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.util;

import java.util.Map;

public class MapEntryImpl implements Map.Entry {

    private Object key;
    private Object value;
    
    public MapEntryImpl(Object key, Object value) {
        this.key = key;
        this.value = value;        
    }

    public Object getValue () {
        return value;
    }
    
    public Object getKey () {
        return key;
    }

    public Object setValue (Object value) {
        throw new UnsupportedOperationException ();
    }
    
    public boolean equals (Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry) o;
            return (key == null ? e.getKey() == null : e.getKey().equals(key))  &&
                (value == null ? e.getValue() == null : e.getValue().equals(value));
 
        } else {
            return false;
        }
    }

    public int hashCode () {
        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode()); 
    }
    
}
