/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.storagemodel.transientimpl;

import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import org.netbeans.mdr.persistence.*;
import org.netbeans.mdr.storagemodel.TransientStorableObject;
import org.netbeans.mdr.storagemodel.TransientStorableClass;
/**
 *
 * @author Tomas Zezula
 */

public class TransientObjectResolverIndex extends TransactionalIndex implements SinglevaluedIndex {
    
    public static final String NAME = "TRANSIENT_OBJECTS_RESOLVER";
    
    private HashMap map;
    private ReferenceQueue queue;
    
    /** Creates a new instance of ObjectResolverIndex */
    public TransientObjectResolverIndex() {
        this.map = new HashMap ();
        this.queue = new ReferenceQueue ();
    }
    
    public void add(Object key, Object value) throws StorageException {
        this.addNoTx (key, value);
        this.txlog.push (new CompensatingTransaction.AddCTx (key, value));
    }
    
    public void addNoTx (Object key, Object value) throws StorageException {
        this.map.put (key, new TransientIndex.KeyedReference (value, this.queue, (MOFID)key));
    }
    
    public boolean put (Object key, Object value) throws StorageException {
        throw new UnsupportedOperationException ();
    }
    
    public void replace (Object key, Object value) throws StorageException {
        throw new UnsupportedOperationException ();
    }
    
    public Object get (Object key) throws StorageException {
        Object result = this.getIfExists (key);
        if (result == null)
            throw new StorageBadRequestException ();
        return result;
    }
    
    public Object getIfExists (Object key) throws StorageException {
        TransientIndex.KeyedReference entry = (TransientIndex.KeyedReference) this.map.get (key);
        if (entry == null)
            return null;
        return entry.get ();
    }
    
    public Object getObjectIfExists (Object key, SinglevaluedIndex index) throws StorageException {
        TransientIndex.KeyedReference entry = (TransientIndex.KeyedReference) this.map.get (key);
        if (entry == null)
            return null;
        Object result = entry.get ();
        if (result == null)
            return null;
        return index.get (result);
    }
    
    public Object getObject (Object key, SinglevaluedIndex index) throws StorageException {
        Object result = this.getObjectIfExists (key, index);
        if (result == null)
            throw new StorageBadRequestException ();
        return result;
    }
    

    public Storage.EntryType getKeyType() throws StorageException {
        return Storage.EntryType.MOFID;
    }
    
    public String getName () throws StorageException {
        return NAME;
    }
    
    public Storage.EntryType getValueType() throws StorageException {
        return Storage.EntryType.STREAMABLE;
    }
    
    public java.util.Set keySet() throws StorageException {
        throw new UnsupportedOperationException ();
    }
    
    public java.util.Collection values () throws StorageException {
        throw new UnsupportedOperationException ();
    }
    
    public boolean remove(Object key) throws StorageException {
        Object result = this.removeNoTx (key, null);
        if (result != null) {
            this.txlog.push ( new CompensatingTransaction.RemoveCTx (key, result));
            return true;
        }
        else {
            return false;
        }
    }
    
    public java.util.Collection queryByKeyPrefix (Object prefix, SinglevaluedIndex repos) {
        throw new UnsupportedOperationException ();
    }
    
    protected Object removeNoTx(Object key, Object value) throws StorageException {
        return this.map.remove (key);
    }
    
}
