/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.mdr.storagemodel.transientimpl;

import java.util.Stack;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.util.Logger;

/**
 *
 * @author Tomas Zezula
 */
public abstract class TransactionalIndex implements Index {
    
    // Transaction log
    protected Stack txlog;
    
    /** Creates a new instance of TransactionalIndex */
    public TransactionalIndex() {
        this.txlog = new Stack();
    }
    
    /** Commits the changes
     *  Clears compensating transaction log
     */
    public void commit() {
        this.txlog.clear();
    }
    
    /** Rollbacks the transaction
     *  Executes the compensating transaction log
     */
    public void rollBack() {
        while (!txlog.empty()) {
            try {
                CompensatingTransaction ctx = (CompensatingTransaction) txlog.pop();
                ctx.perform(this);
            } catch (StorageException se) {
                Logger.getDefault().notify(Logger.INFORMATIONAL, se);
            }
        }
    }
    
    protected abstract void addNoTx(Object key, Object value) throws StorageException;
    
    protected abstract Object removeNoTx(Object key, Object value) throws StorageException;
    
}
