/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.mdr.storagemodel.transientimpl;
import java.util.Map;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.mdr.persistence.StorageException;
/**
 *
 * @author Tomas Zezula
 */
public abstract class CompensatingTransaction {
    
    protected Object key;
    protected Object oldValue;
    
    public CompensatingTransaction (Object key, Object oldValue) {
        this.key = key;
        this.oldValue = oldValue;
    }
    
    public abstract void perform (Object target) throws StorageException;
    
    
    public static class AddCTx extends CompensatingTransaction {
        
        public AddCTx (Object key, Object oldValue) {
            super (key, oldValue);
        }
        
        public void perform (Object target) throws StorageException {
            ((TransactionalIndex)target).removeNoTx (key, oldValue);
        }
    }
    
    public static class RemoveCTx extends CompensatingTransaction {
        
        public RemoveCTx (Object key, Object oldValue) {
            super (key, oldValue);
        }
        
        public void perform (Object target) throws StorageException {
            ((TransactionalIndex)target).addNoTx (key, oldValue);
        }
    }
    
    public static class AddOrderedCTx extends AddCTx {
        
        int index;
        
        public AddOrderedCTx (Object key, Object value, int index) {
            super (key, value);
            this.index = index;
        }
        
        public void perform (Object target) throws StorageException {
            ((TransientMultivaluedOrderedIndex)target).removeNoTx (key, oldValue, index);
        }
        
    }
    
    public static class RemoveOrderedCTx extends RemoveCTx {
        
        int index;
        
        public RemoveOrderedCTx (Object key, Object value, int index) {
            super (key, value);
            this.index = index;
        }
        
        public void perform (Object target) throws StorageException {
            ((TransientMultivaluedOrderedIndex)target).addNoTx (key, oldValue, index);
        }
    }
    
    public static class CreateIndexCTx extends CompensatingTransaction {
        
        public CreateIndexCTx (Object key, Object value) {
            super (key, value);
        }
        
        public void perform (Object target) {
            ((Map)target).remove (key);
        }
    }
    
    public static class DropIndexCTx extends CompensatingTransaction {
        
        public DropIndexCTx (Object key, Object value) {
            super (key, value);
        }
        
        public void perform (Object target) {
            ((Map)target).put (key, oldValue);
        }
    }
    
    
}
