/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.storagemodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.transientimpl.TransientStorage;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

/**
 *
 * @author Tomas Zezula
 */
public class TransientStorableObject extends StorableObject implements Transient {
    
    private ArrayList referentQueue;
    private HashMap attrTxLog;
    
    /** Creates a new instance of TransientStorableObject */
    public TransientStorableObject() {
        super ();
        this.attrTxLog = new HashMap ();
    }
    
    public TransientStorableObject (MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, MOFID classProxy) throws StorageException {
        this (mdrStorage, immediatePackage, meta, classProxy, null);
    }
    
    public TransientStorableObject (MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, MOFID classProxy, Object[] params) throws StorageException {
        super (mdrStorage, immediatePackage, meta, classProxy, params, TransientStorage.STORAGE_ID);
        this.attrTxLog = new HashMap ();
    }
    
    
    public void delete () throws StorageException {
        this.deleteRecursive ();
    }
    
    public void write(java.io.OutputStream outputStream) {
        throw new DebugException ("Trying to write tranient object");
    }
    
    public void read (java.io.InputStream inputStream) {
        throw new DebugException ("Trying to read transient object");
    }
    
    public void addReferent (TransientStorableObject referent) {
        if (this.referentQueue == null) 
            this.referentQueue = new ArrayList ();
        this.referentQueue.add (referent);
    }
    
    public void removeReferent (TransientStorableObject referent) {
        if (this.referentQueue == null)
            return;
        this.referentQueue.remove (referent);
    }
   
    /** Transactional support
     *  the setAttribute is overloaded to allow more efficient transaction
     *  handling
     */
    public void setAttribute (int index, Object value) throws StorageException {
        check ();
        Object oldValue = values[index];
        super.setAttribute (index, value);
        Integer key = new Integer (index);
        if (!attrTxLog.containsKey (key)) {
            this.attrTxLog.put (key, oldValue);
        }
    }
    
     /** Transaction support
      *  commits transaction, clears the compensation transactions log
      */
    public void commit () {
        this.attrTxLog.clear ();
    }
    
    /** Transaction support
      *  rollbacks transaction, performs the compensation transactions log
      */
    public void rollBack () {
        for (Iterator it = this.attrTxLog.keySet ().iterator (); it.hasNext ();) {
            Integer key = (Integer) it.next ();
            Object value = this.attrTxLog.get (key);
            it.remove ();
            try {
                super.setAttribute (key.intValue (), value);
            } catch (StorageException se) {
                Logger.getDefault().notify(Logger.INFORMATIONAL, se);
            }
        }
    }
   
    protected void deleteRecursive () throws StorageException {
        this.getMdrStorage().removeInstance (this);
    }
    
    /** Additional indexing is not supported on transient metadata
     *  the methods are implemented as noops
     */
    
    protected void modifyIndex (int attrIdx, Object oldValue, Object newValue) throws StorageException {
    }
    
    void addToIndex (String proxyId, String endId) throws StorageException {
    }
    
    void removeFromIndex (String proxyId, String endId) throws StorageException {
    }
    
}
