/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.storagemodel;

import java.util.*;
import java.lang.reflect.Array;

import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.util.Logger;

/**
 * Read-only collection. Wraps an inner collection all entries of which are
 * MOF IDs. The accessor methods of this collection return the objects from
 * storage instead of their IDs.
 *
 * @author  Petr Hrebejk, Martin Matula
 */
class CachedCollection implements Collection {
    private final Collection innerCollection;
    private final MdrStorage storage;
    
    /** Creates a new CachedCollection.
     *
     * @param storage the storage to resolve MOF IDs
     * @param innerCollection the collection of MOF IDs
     */
    public CachedCollection(MdrStorage storage, Collection innerCollection) {
        this.innerCollection = innerCollection;
        this.storage = storage;
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object obj) {
        return innerCollection.contains(obj);
    }

    public Object[] toArray(Object[] obj) {
        Object[] value = toArray();
        Object[] result = obj;
        if (value.length > result.length) {
            if (value.getClass() == result.getClass()) {
                return value;
            } else {
                result = (Object[]) Array.newInstance(obj.getClass(), value.length);
            }
        }
        for (int i = 0; i < result.length; i++) {
            result[i] = (i < value.length) ? value[i] : null;
        }
        return result;
    }

    public Iterator iterator() {
        return new CachedIterator(innerCollection.iterator());
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        Object[] array = innerCollection.toArray();

        try {
            for (int i = 0; i < array.length; i++) {
                array[i] = storage.getObject((org.netbeans.mdr.persistence.MOFID) array[i]);
            }
        } catch (Exception e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }

        return array;
    }

    public boolean remove(Object obj) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return innerCollection.size();
    }

    public boolean containsAll(Collection collection) {
        return innerCollection.containsAll(collection);
    }

    public boolean add(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return innerCollection.isEmpty();
    }
    
    private class CachedIterator implements Iterator {
        private final Iterator innerIterator;
        
        private CachedIterator(Iterator innerIterator) {
            this.innerIterator = innerIterator;
        }
        
        public boolean hasNext() {
            return innerIterator.hasNext();
        }

        public Object next() {
            try {
                return storage.getObject((org.netbeans.mdr.persistence.MOFID) innerIterator.next());
            } catch (StorageException e) {
                throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}
