/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.storagemodel;

import java.util.*;
import javax.jmi.reflect.*;

import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

/**
 *
 * @author Martin Matula
 */
public class AttrList extends AttrCollection implements List {
    protected final List innerList;
    
    public AttrList() {
        innerList = (List) inner;
    }
    
    AttrList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc) throws StorageException {
        this(mdrObject, desc, null);
    }
    
    protected AttrList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc, List values) throws StorageException {
        super(mdrObject, desc, values);
        innerList = (List) inner;
    }
    
    protected AttrList(StorableFeatured mdrObject, List values, int maxSize, Class type, String attrName, boolean isRefObject, MOFID metaMofId) {
        super(mdrObject, values, maxSize, type, attrName, isRefObject, metaMofId);
        innerList = values;
    }
    
    public void add(int param, Object obj) {
        checkType(obj);
        checkMaxSize(1);
        checkUnwrap();
        mdrObject.objectWillChange();
        
        if (isIndexed)
            ((StorableObject) mdrObject).removeFromIndex (metaMofId);
        innerList.add(param, obj);
        if (isRefObject) {
            try {
                setAttribComposite((RefObject) obj);
            } catch (StorageException e) {
                throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
            }
        }
        
        if (isIndexed)
            ((StorableObject) mdrObject).addToIndex (metaMofId);
        
        mdrObject.objectChanged();
    }    
    
    public boolean addAll(int param, Collection collection) {
        // should not be called
        throw new DebugException();
    }
    
    public Object get(int param) {
        checkUnwrap();
        return innerList.get(param);
    }
    
    public int indexOf(Object obj) {
        checkUnwrap();
        return innerList.indexOf(obj);
    }
    
    public int lastIndexOf(Object obj) {
        checkUnwrap();
        return innerList.lastIndexOf(obj);
    }
    
    public ListIterator listIterator() {
        checkUnwrap();
        return new AttrListIterator(innerList.listIterator());
    }
    
    public ListIterator listIterator(int param) {
        checkUnwrap();
        return new AttrListIterator(innerList.listIterator(param));
    }
    
    public Object remove(int param) {
        checkUnwrap();
        mdrObject.objectWillChange();
        if (isIndexed)
            ((StorableObject) mdrObject).removeFromIndex (metaMofId);

        Object result = innerList.remove(param);
        if (isRefObject) {
            try {
                clearAttribComposite((RefObject) result);
            } catch (StorageException e) {
                throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
            }
        }
        
        if (isIndexed)
            ((StorableObject) mdrObject).addToIndex (metaMofId);
        
        mdrObject.objectChanged();
        return result;
    }
    
    public Object set(int param, Object obj) {
        checkType(obj);
        checkUnwrap();
        mdrObject.objectWillChange();
        if (isIndexed)
            ((StorableObject) mdrObject).removeFromIndex (metaMofId);
        
        Object result = innerList.set(param, obj);
        if (isRefObject) {
            try {
                clearAttribComposite((RefObject) result);
                setAttribComposite((RefObject) obj);
            } catch (StorageException e) {
                throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
            }
        }
        
        if (isIndexed)
            ((StorableObject) mdrObject).addToIndex (metaMofId);
        
        mdrObject.objectChanged();
        return result;
    }
    
    public List subList(int param, int param1) {
        checkUnwrap();
        return new AttrList(mdrObject, innerList.subList(param, param1), maxSize, type, attrName, isRefObject, metaMofId);
    }
    
    protected class AttrListIterator extends AttrIterator implements ListIterator {
        private final ListIterator innerIterator;
        
        protected AttrListIterator(ListIterator iterator) {
            super(iterator);
            innerIterator = iterator;
        }
        
        public void add(Object obj) {
            checkType(obj);
            checkMaxSize(1);
            
            mdrObject.objectWillChange();
            
            if (isIndexed)
                ((StorableObject) mdrObject).removeFromIndex (metaMofId);
            
            innerIterator.add(obj);
            if (isRefObject) {
                try {
                    setAttribComposite((RefObject) obj);
                } catch (StorageException e) {
                    throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
                }
            }
            
            if (isIndexed)
                ((StorableObject) mdrObject).addToIndex (metaMofId);
            
            mdrObject.objectChanged();
        }
        
        public boolean hasPrevious() {
            return innerIterator.hasPrevious();
        }
        
        public int nextIndex() {
            return innerIterator.nextIndex();
        }
        
        public Object previous() {
            return (lastRead = innerIterator.previous());
        }
        
        public int previousIndex() {
            return innerIterator.previousIndex();
        }
        
        public void set(Object obj) {
            checkType(obj);
            
            mdrObject.objectWillChange();
            
            if (isIndexed)
                ((StorableObject) mdrObject).removeFromIndex (metaMofId);
            
            innerIterator.set(obj);
            if (isRefObject) {
                try {
                    clearAttribComposite((RefObject) lastRead);
                    setAttribComposite((RefObject) obj);
                } catch (StorageException e) {
                    throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
                }
            }
            
            if (isIndexed)
                ((StorableObject) mdrObject).addToIndex (metaMofId);
            
            mdrObject.objectChanged();
        }
    }
}
