/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.storagemodel;

import java.util.*;
import javax.jmi.reflect.*;

import org.netbeans.mdr.persistence.StorageException;

/**
 *
 * @author Martin Matula
 */
public class AttrImmutUList extends AttrImmutList {
    
    public AttrImmutUList() {
    }
    
    AttrImmutUList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc) throws StorageException {
        this(mdrObject, desc, null);
    }
    
    AttrImmutUList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc, Collection values) throws StorageException {
        Class type = desc.getType();
        if (values == null) {
            data = new Object[0];
        } else {
            data = values.toArray();
            Set helperSet = new HashSet(data.length, 1);
            for (int i = 0; i < data.length; i++) {
                if (data[i] == null) {
                    throw new NullPointerException();
                }
                if (!type.isInstance(data[i])) {
                    throw new TypeMismatchException(type, data[i], getMetaElement(mdrObject.getMdrStorage(), desc.getMofId()));
                }
                if (!helperSet.add(data[i])) {
                    throw new DuplicateException(data[i], getMetaElement(mdrObject.getMdrStorage(), desc.getMofId()));
                }
            }
        }

        if ((data.length < desc.getMinSize()) || ((desc.getMaxSize() > -1) && (data.length > desc.getMaxSize()))) {
            throw new WrongSizeException(getMetaElement(mdrObject.getMdrStorage(), desc.getMofId()));
        }

        if (type.isInstance(RefObject.class)) {
            setAttribComposite(mdrObject.getMofId(), values, desc.getMofId());
        }
    }
}
