/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.storagemodel;

import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

/**
 *
 * @author Martin Matula
 * @version 
 */
public class AssociationLink {

    private final StorableObject end1;
    private final StorableObject end2;
    
    /** Creates new AssociationLinkImpl */
    public AssociationLink(StorableObject end1, StorableObject end2) {
        this.end1 = end1;
        this.end2 = end2;
    }
    
    public AssociationLink(MdrStorage storage, MOFID end1, MOFID end2) {
        try {
            this.end1 = (StorableObject) storage.getObject(end1);
            this.end2 = (StorableObject) storage.getObject(end2);
        } catch (Exception e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }

    public StorableObject getFirstEnd() {
        return end1;
    }
    
    public StorableObject getSecondEnd() {
        return end2;
    }
}
