/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 *
 * @author  mmatula
 * @version
 */
public class Utils extends Object {
    public static void write(OutputStream outputStream, Object object, Storage storage) throws IOException {
        if (object instanceof Map) {
            outputStream.write(IOUtils.T_MAP);
            Map temp = (Map) object;
            IOUtils.writeInt(outputStream, temp.size());
            Map.Entry key;
            for (Iterator it = temp.entrySet().iterator(); it.hasNext();) {
                key = (Map.Entry) it.next();
                write(outputStream, key.getKey(), storage);
                write(outputStream, key.getValue(), storage);
            }
        } else if (object instanceof Collection) {
            outputStream.write(IOUtils.T_COLLECTION);
            Collection col = (Collection) object;
            IOUtils.writeInt(outputStream, col.size());
            for (Iterator it = col.iterator(); it.hasNext();) {
                write(outputStream, it.next(), storage);
            }
        } else if (object instanceof MOFID) {
            outputStream.write(IOUtils.T_MOFID);
            IOUtils.writeMOFID(outputStream, (MOFID)object, storage);
        } else {
            IOUtils.write(outputStream, object);
        }
    }
    
    public static Object read(InputStream inputStream, Storage storage) throws IOException {
        int type = inputStream.read();
        switch (type) {
            case IOUtils.T_MAP: {
                int size = IOUtils.readInt(inputStream);
                Map result = new HashMap(size);
                for (int i = 0; i < size; i++) {
                    result.put(read(inputStream, storage), read(inputStream, storage));
                }
                return result;
            } 
            case IOUtils.T_COLLECTION: {
                int size = IOUtils.readInt(inputStream);
                java.util.List result = new java.util.ArrayList(size);
                for (int i = 0; i < size; i++) {
                    result.add(read(inputStream, storage));
                }
                return result;
            }
            case IOUtils.T_MOFID: {
                return IOUtils.readMOFID(inputStream, storage);
            } 
            default: {
                return IOUtils.read(inputStream, null, null, type);
            }
        }
    }
}
