/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.*;

import org.netbeans.mdr.persistence.*;

/**
* This represents a page fetched from the cache.
*/
public class CachedPage extends IntrusiveList.Member {

    /** Description of which page this is */
    PageID key;
    /** How many times this page has been pinned and not unpinned */
    private int pinCount;
    /** true if this page has been modified */
    boolean isDirty;
    /** true if the log file must be flushed before this page can be written */
    boolean heldForLog;

    /** the contents of the page */
    public byte contents[];

    /* cache we were created by */
    private FileCache owner;

    /** create a page of the specified size 
    * @param size the page size for the cache
    */
    CachedPage(int size) {
        key = null;
        pinCount = 0;
        isDirty = false;
        heldForLog = false;
        owner = null;
        contents = new byte[size];
    }
    
    public FileCache getOwner() {
        return owner;
    }

    /** Make this page writable.  If it was not writable previously,
    * this causes it to be logged.  This must be called before the page
    * is modified.  If the cache is not currently in a transaction,
    * this implicitly begins one.
    * @exception StorageException I/O error logging the page
    */
    public synchronized void setWritable() throws StorageException{
        owner.setWritable(this);
    }

    /** reinitialize thie object to point to a different file page 
    * @param id the file and page number this will become
    */
    void reInit(FileCache owner, PageID id) {
        this.owner = owner;
        key = id;
        pinCount = 0;
        isDirty = false;
        heldForLog = false;
    }
    
    public int pin(FileCache owner) {
        assert pinCount == 0 || this.owner == owner;
        this.owner = owner;
        return pinCount++;
    }
    
    public int getPinCount() {
        return pinCount;
    }
    
    public int innerUnpin() {
        pinCount--;
        return pinCount;
    }
        
    /** client calls this when it is done with the page */
    public void unpin() throws StorageException {
        owner.unpin(this);
    }

    /** format debugging info */
    public String toString() {
        StringBuffer debug = new StringBuffer("" + key);
        if (pinCount > 0)
            debug.append(" pin count: " + pinCount);
        if (isDirty)
            debug.append(" dirty");
        if (heldForLog)
            debug.append(" held");
        debug.append("\n");

        int j = 0;
        for (int i = 0; i < contents.length; i++, j++) {
            if (j >= 16) {
                debug.append("\n");
                j = 0;
            }
            int data = (int)(contents[i]) & 0xFF;
            debug.append(Integer.toHexString(data));
            debug.append(" ");
        }
        debug.append("\n");

        return debug.toString();
    }
                

}
