/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.ByteArrayInputStream;
import org.netbeans.mdr.persistence.*;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.*;

/**
 * BtreePageSource whose pages are MOF repository objects
 *
 * @author	Dana Bergen
 * @version	1.0
 */
public class BtreeMDRSource extends Object implements BtreePageSource {

    BtreeStorage                     storage;
    MofidGenerator		gen;
    private int			pageSize;
    private EntryTypeInfo	pageIdInfo;
    private byte[] noPageId;
    
    public BtreeMDRSource(BtreeStorage storage, int pageSize) throws StorageException {
        this.storage = storage;
	this.pageSize = pageSize;	
	gen = ((BtreeDatabase) storage.getPrimaryIndex()).getMofidGenerator();
	pageIdInfo = EntryTypeInfo.getEntryTypeInfo(Storage.EntryType.MOFID, storage);
	noPageId = this.storage.getMOFIDData (BtreeFactory.nullMOFID);
    }

    public BigKeyPage newBigKeyPage(Btree btree) throws StorageException {
        BigKeyPage page = new BigKeyPage();
	initNewPage(page, btree);
	return page;
    }

    public BtreePage newPage(Btree btree) throws StorageException {

	BtreePage page = btree.pageFactory();
	initNewPage(page, btree);
	return page;
    }

    private void initNewPage(BtreePage page, Btree btree) throws StorageException {

	MOFID pageMOFID = new MOFID((BtreeStorage)this.storage);
        byte[] mofBytes = this.storage.getMOFIDData (pageMOFID);
	page.init(btree, mofBytes, new byte[pageSize], true);
        BtreeDatabase repos = (BtreeDatabase) storage.getPrimaryIndex();
	repos.add(pageMOFID, page);
	repos.objectStateChanged(pageMOFID);
    }

    public BtreePage getPage(byte[] pageId, Btree btree) 
    					throws StorageException {
	BtreePage page;
        MOFID mofId = this.storage.readMOFIDData (new ByteArrayInputStream (pageId));
	page = (BtreePage) ((BtreeDatabase) storage.getPrimaryIndex()).get(mofId);
	page.init(btree, pageId, page.pageBuffer, false);
	return page;
    }

    public BtreePage getRootPage(Btree btree) throws StorageException {
        return newPage(btree);
    }
    
    public void unpinPage(BtreePage page) {
        /* nothing we need to do here */
    }

    public void unpinPage(BigKeyPage page) {
        /* nothing we need to do here */
    }

    public void dirtyPage(BtreePage page) throws StorageException {
        MOFID mofId = this.storage.readMOFIDData (new ByteArrayInputStream (page.pageId));
        ((BtreeDatabase) storage.getPrimaryIndex()).objectStateChanged(mofId);
    }

    public EntryTypeInfo getPageIdInfo() {
        return pageIdInfo;
    }

    public int getPageIdLength() {
        return MOFID.LENGTH;
    }

    public int getPageSize() {
        return pageSize;
    }

    /**
     * Set the passed-in pageId to contain the special value noPageId
     */
    public void setNoPage(byte[] pageId) {

        System.arraycopy(noPageId, 0, pageId, 0, pageId.length);
    }

    /**
     * Test whether the passed-in pageId contains the special value noPageId
     */
    public boolean isNoPage(byte[] pageId) {
	
	for (int i = 0; i < pageId.length; i++) {
	    if (pageId[i] != noPageId[i]) {
	        return false;
	    }
	}
	return true;
    }
    
    /** get the next unique ID for this repository */
    public long getNextMofid() {
    	return gen.getNextMofid();
    }

    /** Get the prefix for this repository */
    public String getMofidPrefix() {
    	return gen.getMofidPrefix();
    }

    public BtreeStorage getStorage() {
        return storage;
    }
    
}
