/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.io.PrintStream;

public class TreeMetrics {

    private int depth;
    private int numOfPages;
    private long totalBytes;
    private long usedBytes;
    private long numOfEntries;
    private long numOfLeafEntries;
    
    public TreeMetrics(int depth, int numOfPages, long totalBytes, long usedBytes, long numOfEntries, 
        long numberOfLeafEntries) {
        
        this.depth = depth;
        this.numOfPages = numOfPages;
        this.totalBytes = totalBytes;
        this.usedBytes = usedBytes;
        this.numOfEntries = numOfEntries;
        this.numOfLeafEntries = numberOfLeafEntries;
    }

    /*
    public TreeMetrics() {
        this.depth = 0;
        this.numOfPages = 0;
        this.totalBytes = 0;
        this.usedBytes = 0;
        this.numOfEntries = 0;
    }
     */
    
    public int getDepth() {
        return depth;
    }
    
    public int getNumberOfPages() {
        return numOfPages;
    }
    
    public double getLoadFactor() {
        return totalBytes > 0 ? (double)usedBytes / (double)totalBytes : 0;
    }

    public long getTotalBytes() {
        return totalBytes;
    }

    public long getUsedBytes() {
        return usedBytes;
    }
    
    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setNumberOfPages(int numOfPages) {
        this.numOfPages = numOfPages;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public void setUsedBytes(long usedBytes) {
        this.usedBytes = usedBytes;
    }

    public void print(PrintStream stream) {
        stream.println("depth: " + depth); // NOI18N
        stream.println("#pages: " + numOfPages); // NOI18N
        stream.println("#entries: " + numOfEntries); // NOI18N
        stream.println("#leaf entries: " + numOfLeafEntries); // NOI18N
        stream.println("used bytes: " + usedBytes); // NOI18N
        stream.println("total bytes: " + totalBytes); // NOI18N
        stream.println("load factor: " + getLoadFactor()); // NOI18N
    }
    
    public static TreeMetrics computeParent(TreeMetrics[] m, long tBytes, long uBytes, long entries) {
        int d = 0;
        int pages = 0;
        long bytes = 0;
        long used = 0;
        long entrs = 0;
        long leafEntries = 0;
        
        for (int x = 0; x < m.length; x++) {
            if (m[x].getDepth() > d) {
                d = m[x].getDepth();
            }
            pages += m[x].getNumberOfPages();
            bytes += m[x].getTotalBytes();
            used += m[x].getUsedBytes();
            entrs += m[x].getNumOfEntries();
            leafEntries += m[x].getNumOfLeafEntries();
        }
        return new TreeMetrics(d + 1, pages + 1, bytes + tBytes, used + uBytes, entrs + entries, leafEntries);
    }

    public long getNumOfEntries() {
        return numOfEntries;
    }

    public void setNumOfEntries(long numOfEntries) {
        this.numOfEntries = numOfEntries;
    }

    public long getNumOfLeafEntries() {
        return numOfLeafEntries;
    }

    public void setNumOfLeafEntries(long numOfLeafEntries) {
        this.numOfLeafEntries = numOfLeafEntries;
    }
    
}   
