/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

/**
 * EntryTypeInfo implementation for type String
 *
 * @author	Dana Bergen
 * @version	1.0
 */

public class StringInfo extends EntryTypeInfo {
    public String typeName() {
        return "String";
    }

    public byte[] toBuffer(Object object) {
        
        if (!(object instanceof String)) {
	    return null;
	} else {
            String s = (String)object;
            int l = s.length();
            char[] arr = new char[l];
            int utflen = 0;
            char c;
            
            s.getChars(0, l, arr, 0);
            for (int i = 0; i < l; i++) {
                c = arr[i];
                if (c < 0x7f) {
                    utflen++;
                } else if (c > 0x7ff) {
                    utflen += 3;
                } else {
                    utflen += 2;
                }
            }
            byte[] encoded = new byte[utflen];
            int offset = 0;
            for (int i = 0; i < l; i++) {
                c = arr[i];
                if (c < 0x007f) {
                    encoded[offset++] = (byte)c;
                } else if (c > 0x07ff) {
                    encoded[offset++] = (byte)(0xe0 | ((c >> 12) & 0x0f));
                    encoded[offset++] = (byte)(0x80 | ((c >> 6) & 0x3f));
                    encoded[offset++] = (byte)(0x80 | (c & 0x3f));
                } else {
                    encoded[offset++] = (byte)(0xc0 | ((c >> 6) & 0x1f));
                    encoded[offset++] = (byte)(0x80 | (c & 0x3f));
                }
            }
            return encoded;
	}
    }
    
    static int fromBufferCount = 0;

    public Object fromBuffer(byte[] buffer) {
        int length = buffer.length;
        int offset = 0;
        StringBuffer sb = new StringBuffer(length);
        do {
            int b = buffer[offset++] & 0xff;
            length--;
            if (b >= 0xe0) {
                b = (b & 0x0f) << 12;
                b |= (buffer[offset++] & 0x3f) << 6;
                b |= buffer[offset++] & 0x3f;
                length--;
                length--;
            } else if (b >= 0xc0) {
                b = (b & 0x1f) << 6;
                b |= buffer[offset++] & 0x3f;
                length--;
            }
            sb.append((char)b);
        } while (length > 0);
        return new String(sb);
    }
    
    final int compareImpl(byte[] key1buffer, byte[] key2buffer, int offset, int length) {
        int key1len = key1buffer.length;
        byte c1, c2;
        int key1offset = 0;

        int n = Math.min(key1len, length);
        while (n-- > 0) {
            c1 = key1buffer[key1offset++];
            c2 = key2buffer[offset++];
            if (c1 != c2)
                return c1 - c2;
        }
        return key1len - length;
    }

    public byte compare(byte[] key1buffer, byte[] key2buffer, int offset, int length) {
	int result = compareImpl(key1buffer, key2buffer, offset, length);
	if (result < 0) {
	    return LESS;
	} else if (result > 0) {
	    return GREATER;
	} else {
	    return EQUAL;
	}
    }

    public int getLength() {
        // length is variable
	return 0;
    }

    public boolean isFixedLength() {
        return false;
    }
}
