/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

/**
 * Represents the location of an entry in a Btree.
 */
final class SearchResult extends Object {

    boolean 	matched;	/* was it an exact match */
    int		entryNum;	/* entry # on the page */
    BtreePage	page;		/* page on which entry was found */
    int		skipCount;	/* For non-unique keys, how many sibling
    				 * pages were traversed to reach this entry
				 */

    SearchResult(boolean matched, int entryNum, BtreePage page) {
	this.matched = matched;
	this.entryNum = entryNum;
	this.page = page;
    }

    SearchResult(SearchResult source) {
	this.matched = source.matched;
	this.entryNum = source.entryNum;
	this.page = source.page;
    }

    void copy(SearchResult target) {
	target.matched = matched;
	target.entryNum = entryNum;
	target.page = page;
	target.skipCount = skipCount;
    }
}
