/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.io.*;
import org.netbeans.mdr.persistence.*;

/**
 * Encapsulates the behavior of an entry of a given type.
 *
 * @author	Dana Bergen
 * @version	1.0
 */
public abstract class EntryTypeInfo extends Object {

    static final byte EQUAL = 0;
    static final byte GREATER = 1;
    static final byte LESS = -1;

    /**
     * Returns an IntInfo, MOFIDInfo, or StringInfo.
     *
     * @param	type	type to return Info object for
     *
     * @return	a new IntInfo, MOFIDInfo, or StringInfo
     */
    public static EntryTypeInfo getEntryTypeInfo(
    	Storage.EntryType type, Storage storage) {

        if (type == Storage.EntryType.INT) {
	    return new IntInfo();
	} else if (type == Storage.EntryType.MOFID) {
	    return new MOFIDInfo(storage);
	} else if (type == Storage.EntryType.STRING) {
	    return new StringInfo();
	} else {
	    return null;
	}
    }
    
    /**
     * Store the value of the object in a byte array.
     * @param	object
     * @return	newly allocated byte array
     */
    public abstract byte[] toBuffer(Object object);
    /**
     * Create an object from the contents of the byte array.
     * @param buffer
     * @return new object
     */
    public abstract Object fromBuffer(byte[] buffer);
    /**
     * Like fromBuffer, except that if this type is a key, returns object
     * associated with the key
     * @param buffer
     * @return new object
     */
    public Object objectFromBuffer(byte[] buffer, SinglevaluedIndex repos) {
        return fromBuffer(buffer);
    }
    
    /**
     * Compare two items of this type which are stored in byte arrays.
     *
     * @param key
     * @param key2
     * @param	offset		offset into key2 of target key
     * @param	length		length in key2 of target key
     *
     * @return	Returns one of:
     * <p>EQUAL if the two keys are equal
     * <p>GREATER if key greater than key2
     * <p>LESS if key less than key2
     */
    public abstract byte compare(byte[] key, byte[] key2, int offset, int length);
    /**
     * Returns the length of an item of this type, or 0 if variable length.
     */
    public abstract int getLength();
    /**
     * Returns true if this is a fixed length type, otherwise returns false;
     */
    public abstract boolean isFixedLength();
    /**
     * Returns the name of this type as a String.
     */
    public abstract String typeName();

}
