/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import org.netbeans.mdr.persistence.*;
import java.util.*;

public class BtreeListByKeyRepos extends AbstractSequentialList {

    private BtreeListByKey innerList;
    private SinglevaluedIndex repos;
    
    BtreeListByKeyRepos(BtreeListByKey innerList, SinglevaluedIndex repos) {
        this.innerList = innerList;
        this.repos = repos;
    }
    
    public int size() {
        return innerList.size ();
    }
    
    public boolean isEmpty() {
        return innerList.isEmpty();
    }
    
    public boolean add(Object o) {
        ListIterator it = listIterator();
        while (it.hasNext()) it.next();
        it.add(o);
        return true;
    }
    
    public boolean addAll(Collection c) {
        ListIterator it = listIterator();
        while (it.hasNext()) it.next();
        boolean result = false;
        for (Iterator cit = c.iterator(); cit.hasNext();) {
            try {
                it.add(cit.next());
                result = true;
            } catch (RuntimeStorageException e) {
            }
        }
        return result;
    }

    public ListIterator listIterator(int index) {
        return innerList.listIterator (index, repos);
    }

}
