/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence;

/** Representation index where exactly one value is
 * associated with each key.
 * @author Pavel Buzek
 * @version
 */

public interface SinglevaluedIndex extends Index {
    
    /** Associates the specified value with the specified key in this index.
     * @return true if there was an item in this index that was associated with the key
     * prior to this call
     * @param key
     * @param value
     * @throws StorageException
     */
    public boolean put(Object key,Object value) throws StorageException;
    
    /** Replaces the original value associated with the specified key in this index
     * with new value. If no value was associated with this key prior to this call
     * StorageBadRequestException is thrown.
     * @param key
     * @param value
     * @throws StorageException
     * @throws StorageBadRequestException
     */
    public void replace(Object key, Object value) throws StorageException, StorageBadRequestException;
    
    /** Returns the value to which this index maps the specified key.
     * StorageBadRequestException is thrown if there is no value for the key.
     * @return value associated with specified key
     * @param key
     * @throws StorageException
     * @throws StorageBadRequestException
     */
    public Object get(Object key) throws StorageException, StorageBadRequestException;

    /** Like get, but if the index contains keys, this returns the object 
     * corresponding to the key
     * @return
     * @param key
     * @throws StorageException
     */
    public Object getObject (Object key, SinglevaluedIndex repos) throws StorageException;

    /** Returns the value to which this index maps the specified key
     * or null if there is no value for this key.
     * @return value associated with specified key or null
     * @param key
     * @throws StorageException
     */
    public Object getIfExists (Object key) throws StorageException;
    
    /** Like getIfExists, but if the index contains keys, this returns the object 
     * corresponding to the key
     * @return
     * @param key
     * @throws StorageException
     */
    public Object getObjectIfExists (Object key, SinglevaluedIndex repos) throws StorageException;

    /** Returns a collection view of the values contained in this index.
     * Returned collection is read only and may not be modified.
     * If this index has no items, empty Collection is returned.
     * @return
     * @throws StorageException
     */
    public java.util.Collection values () throws StorageException;
    
    /** Returns a collection view of {@link java.util.Map.Entry} key-value pairs in the index,
     * where key matches the queried prefix. Values are objects (as returned by {@link getObject}
     * method).
     * @param prefix queried prefix
     * @param repos primary index
     * @return
     * @throws StorageException
     * @throws UnsupportedOperationException thrown if the index does not support quries on
     * prefixes (due to unsuitable key entry type, etc.)
     */
    public java.util.Collection queryByKeyPrefix (Object prefix, SinglevaluedIndex repos) throws StorageException;
}
