/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence;

import java.io.*;

/**
* This is thrown when a StorageException needs to be thrown across a boundary
* that does not allow checked exceptions: for instance, when using a
* Collections interface to iterate through a set of MDR objects.
* The StorageException is converted to a RuntimeStorageException.
* A RuntimeStorageException returns the stack trace information of the
* original StorageException occurred, since this is far more useful 
* than the stack trace of the point where the exception was converted.
*/

public class RuntimeStorageException extends RuntimeException {

    /** The original StorageException that we are converting to a 
    * RuntimeException 
    */
    private StorageException storageExcept;

    /** this constructs a RuntimeStorageException from an StorageException
    * @param err the StorageException
    */
    public RuntimeStorageException(StorageException err) {
	super(err.getMessage());
	storageExcept = err;
    }

    /** return the original StorageException's message */
    public String getMessage() {
	return storageExcept.getMessage();
    }
	
    /** return the original StorageException's localized message */
    public String getLocalizedMessage() {
	return storageExcept.getLocalizedMessage();
    }

    /** print the original StorageException's stack trace */
    public void printStackTrace() {
	storageExcept.printStackTrace();
    }

    /** print the original StorageException's stack trace */
    public void printStackTrace(PrintStream ps) {
	storageExcept.printStackTrace(ps);
    }

    /** print the original StorageException's stack trace */
    public void printStackTrace(PrintWriter pw) {
	storageExcept.printStackTrace(pw);
    }
	
}
