/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence;

/** Representation of non-unique index. Sorted list of values is
 * associated with each key.
 * @author Pavel Buzek
 * @version
 */
public interface MultivaluedOrderedIndex extends MultivaluedIndex {
    /** Returns a list view of the values assosiated in the index with specified key.
     * Returned collection is live and modifiable.
     * If there are no values associated with the key empty collection is returned.
     * @param key
     * @return
     */
    public java.util.List getItemsOrdered (Object key) throws StorageException;

      /** Like getItemsOrdered, but if the index contains keys, this returns the objects 
     * corresponding to the key
     * @return
     * @param key
     * @throws StorageException
     */
    public java.util.Collection getObjectsOrdered (Object key, SinglevaluedIndex repos) throws StorageException;
  
    /** Inserts the specified element at the specified position in the list of values
     * associated with the specified key.
     * Throws StorageBadRequestException if the index is out of range.
     * @param key
     * @param index
     * @param value
     */
    public void add (Object key, int index, Object value) throws StorageException;
    
    /** Removes the element at the specified position in the list of values
     * associated with the specified key.
     * @return true if this index changed as a result of this call
     * @param key
     * @param index
     */
    public boolean remove (Object key, int index) throws StorageException;
    
    /** Replaces the element at the specified position in the list of values
     * associated with the specified key with the specified element.
     * Throws StorageBadRequestException if the index is out of range.
     * @param key
     * @param index
     * @param element
     * @throws StorageException
     */
    public void replace(Object key, int index, Object element) throws StorageException;
}
