/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers.gen;

import java.util.*;
import java.io.*;

import org.netbeans.mdr.storagemodel.*;
import org.netbeans.mdr.util.*;
import javax.jmi.model.*;

/**
 *
 * @author Martin Matula, Dusan Balek
 * @version 
 */
class InstanceGenerator extends FeaturedGenerator {
    
    InstanceGenerator(String name, Class ifc, Class handler, StorableObject storable, Class custom) {
        super(name, ifc, handler, storable, custom);
    }

    protected String getConstructorDescriptor() {
        return "(Lorg/netbeans/mdr/storagemodel/StorableObject;)V"; //NOI18N
    }
        
    protected MethodInfo[] generateMethods() throws IOException {
        try {
            ArrayList methods = new ArrayList();
            HashSet createdMethods = new HashSet();
	    methods.add(generateConstructor());
            for (Iterator it = new ContainsIterator(obj.getMetaObject()); it.hasNext();) {
                StorableObject element = (StorableObject) it.next();
                String elementName = (String) element.getAttribute(MOFConstants.SH_MODEL_MODEL_ELEMENT_NAME);
                String metaTypeName = (String) element.getMetaObject().getAttribute(MOFConstants.SH_MODEL_MODEL_ELEMENT_NAME);
                String substName = TagSupport.getSubstName(element, elementName, metaTypeName);
                if (metaTypeName.equals(MOFConstants.SH_MODEL_ATTRIBUTE)) {
                    VisibilityKind visibility = (VisibilityKind) element.getAttribute(MOFConstants.SH_MODEL_GENERALIZABLE_ELEMENT_VISIBILITY);
                    ScopeKind scope = (ScopeKind) element.getAttribute(MOFConstants.SH_MODEL_FEATURE_SCOPE);
                    if (visibility.equals(VisibilityKindEnum.PUBLIC_VIS) && scope.equals(ScopeKindEnum.INSTANCE_LEVEL)) {
                        String attrName = firstUpper(substName);
                        String attrTypeName = TagSupport.getDataTypeName(getAttrType(element));
                        MultiplicityType multiplicity = (MultiplicityType) element.getAttribute(MOFConstants.SH_MODEL_STRUCTURAL_FEATURE_MULTIPLICITY);
                        if (multiplicity.getUpper() == 1) {
                            String name;
                            String setterName;
                            if (attrTypeName.equals("java.lang.Boolean")) { //NOI18N
                                if (attrName.substring(0, 2).equals("Is")) name = firstLower(attrName); //NOI18N
                                else name = "is" + attrName; //NOI18N
                                setterName = "set" + name.substring(2); //NOI18N
                            } else {
                                name = "get" + attrName; //NOI18N
                                setterName = "set" + attrName; //NOI18N
                            }
                            String getterType = attrTypeName;
                            if (multiplicity.getLower() == 1)
                                getterType = getPrimitiveName(getterType);
                            String sign = name + getMethodDescriptor(new String[0], getterType);
                            if (!createdMethods.contains(sign)) {
                                methods.addAll(getFeatureMethod(name, new String[0], getterType, M_GET_NAME, M_GET_DESC, M_GET_TYPE, element, (StorableFeatured)obj, "_getAttribute")); //NOI18N
                                createdMethods.add(sign);
                            }
                            boolean changeable = ((Boolean) element.getAttribute(MOFConstants.SH_MODEL_STRUCTURAL_FEATURE_IS_CHANGEABLE)).booleanValue();
                            if (changeable) {
                                sign = setterName + getMethodDescriptor(new String[] {getterType}, "void"); //NOI18N
                                if (!createdMethods.contains(sign)) {
                                    methods.addAll(getFeatureMethod(setterName, new String[] {getterType}, "void", M_SET_NAME, M_SET_DESC, M_SET_TYPE, element, (StorableFeatured)obj, "_setAttribute")); //NOI18N
                                    createdMethods.add(sign);
                                }
                            }
                        } else if (multiplicity.getUpper() != 0) {
                            String sign = "get" + attrName + getMethodDescriptor(new String[0], (multiplicity.isOrdered() ? DT_ORDERED : DT_MULTIVALUED)); //NOI18N
                            if (!createdMethods.contains(sign)) {
                                methods.addAll(getFeatureMethod("get" + attrName, new String[0], (multiplicity.isOrdered() ? DT_ORDERED : DT_MULTIVALUED), M_GET_NAME, M_GET_DESC, M_GET_TYPE, element, (StorableFeatured)obj, "_getAttribute")); //NOI18N
                                createdMethods.add(sign);
                            }
                        }
                    }
                } else if (metaTypeName.equals(MOFConstants.SH_MODEL_OPERATION)) {
                    VisibilityKind visibility = (VisibilityKind) element.getAttribute(MOFConstants.SH_MODEL_GENERALIZABLE_ELEMENT_VISIBILITY);
                    if (visibility.equals(VisibilityKindEnum.PUBLIC_VIS)) {
                        Collection parameters = new ArrayList();
                        String operType = "void"; //NOI18N
                        for (Iterator itt = ((List) element.getReference(MOFConstants.SH_MODEL_NAMESPACE_CONTENTS)).iterator(); itt.hasNext();) {
                            StorableObject el = (StorableObject) itt.next();
                            String mtName = (String) el.getMetaObject().getAttribute(MOFConstants.SH_MODEL_MODEL_ELEMENT_NAME);
                            if (mtName.equals(MOFConstants.SH_MODEL_PARAMETER)) {
                                DirectionKind direction = (DirectionKind) el.getAttribute(MOFConstants.SH_MODEL_PARAMETER_DIRECTION_KIND);
                                if (direction.equals(DirectionKindEnum.RETURN_DIR))
                                    operType = getAttrTypeName(el);
                                else
                                    parameters.add(getAttrTypeName(el) + (direction.equals(DirectionKindEnum.IN_DIR) ? "" : "[]")); //NOI18N
                            }
                        }
                        String[] prms = (String[])parameters.toArray(new String [parameters.size()]);
                        String sign = substName + getMethodDescriptor(prms, operType);
                        if (!createdMethods.contains(sign)) {
                            MethodInfo mInfo = getOperationMethod(substName, prms, operType, elementName);
                            if (mInfo != null) {
                                Collection exceptions = (Collection) element.getReference(MOFConstants.SH_MODEL_OPERATION_EXCEPTIONS);
                                short[] declaredExceptions = new short[exceptions.size()];
                                int i = 0;
                                for (Iterator itt = exceptions.iterator(); itt.hasNext(); i++)
                                    declaredExceptions[i] = cp.getClass(dotToSlash(TagSupport.getTypeFullName((StorableObject)itt.next())));
                                mInfo.setDeclaredExceptions(declaredExceptions);
                                methods.add(mInfo);
                            }
                            createdMethods.add(sign);
                        }
                    }
                } else if (metaTypeName.equals(MOFConstants.SH_MODEL_REFERENCE)) {
                    VisibilityKind visibility = (VisibilityKind) element.getAttribute(MOFConstants.SH_MODEL_GENERALIZABLE_ELEMENT_VISIBILITY);
                    if (visibility.equals(VisibilityKindEnum.PUBLIC_VIS)) {
                        String refName = firstUpper(substName);
                        String refType = TagSupport.getDataTypeName(getAttrType(element));
                        MultiplicityType multiplicity = (MultiplicityType) element.getAttribute(MOFConstants.SH_MODEL_STRUCTURAL_FEATURE_MULTIPLICITY);
                        if (multiplicity.getUpper() == 1) {
                            String sign = "get" + refName + getMethodDescriptor(new String[0], refType); //NOI18N
                            if (!createdMethods.contains(sign)) {
                                methods.addAll(getHandlerMethod("get" + refName, new String[0], refType, M_GET_NAME + "R", M_GET_DESC, M_GET_TYPE, elementName)); //NOI18N
                                createdMethods.add(sign);
                            }
                            boolean changeable = ((Boolean) element.getAttribute(MOFConstants.SH_MODEL_STRUCTURAL_FEATURE_IS_CHANGEABLE)).booleanValue();
                            if (changeable) {
                                sign = "set" + refName + getMethodDescriptor(new String[] {refType}, "void"); //NOI18N
                                if (!createdMethods.contains(sign)) {
                                    methods.addAll(getHandlerMethod("set" + refName, new String[] {refType}, "void", M_SET_NAME + "R", M_SET_DESC, M_SET_TYPE, elementName)); //NOI18N
                                    createdMethods.add(sign);
                                }
                            }
                        } else if (multiplicity.getUpper() != 0) {
                            String sign = "get" + refName + getMethodDescriptor(new String[0], (multiplicity.isOrdered() ? DT_ORDERED : DT_MULTIVALUED)); //NOI18N
                            if (!createdMethods.contains(sign)) {
                                methods.addAll(getHandlerMethod("get" + refName, new String[0], (multiplicity.isOrdered() ? DT_ORDERED : DT_MULTIVALUED), M_GET_NAME + "R", M_GET_DESC, M_GET_TYPE, elementName)); //NOI18N
                                createdMethods.add(sign);
                            }
                        }
                    }
                }
            }
            
            MethodInfo[] mtds = super.generateMethods();
            for(int i = 0; i < mtds.length; i++)
                methods.add(mtds[i]);
            return (MethodInfo[]) methods.toArray(new MethodInfo[methods.size()]);
        }catch (Exception e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
}
