/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers;

import javax.jmi.reflect.*;

import java.util.*;
import java.io.*;
import java.lang.reflect.*;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.storagemodel.*;

/**
 *
 * @author Martin Matula
 * @version 
 */
public abstract class StructImpl extends ImplClass implements RefStruct {
    private final List fields;
    // field values
    private final Map values;
    // fully qualified name of metaobject
    private final List qualifiedName;

    private static Class getStructClass(MDRClassLoader loader, Class ifc) throws IllegalArgumentException {
        check(loader, ifc);
        Map cache = getLoaderCache(loader);
        String className = getName(ifc);
        Class result = getFromCache(cache, ifc, className);
        
        if (result == null) {
            try {
                byte[] structClassFile = StructGenerator.generateStruct(className, ifc);
                result = loader.defineClass(className, structClassFile);
            } finally {
                releaseCache(cache, result, className);
            }
        }
        
        return result;
    }
    
    public static RefStruct newInstance(DatatypeDescriptor dataType, Object fieldValues[]) {
        try {
            HashMap values = new HashMap(fieldValues.length, 1);
            int i = 0;
            Iterator types = dataType.getMemberTypes().iterator();
            for (Iterator it = dataType.getMembers().iterator(); it.hasNext(); i++) {
                Class type = (Class) types.next();
                if (fieldValues[i] != null && !type.isInstance(fieldValues[i])) {
                    throw new TypeMismatchException(type, fieldValues[i], null);
                }
                values.put(it.next(), fieldValues[i]);
            }
            return newInstance(BaseObjectHandler.resolveInterface(dataType.getIfcName()), dataType.getMembers(), values, dataType.getTypeName());
        } catch (ClassNotFoundException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    public static RefStruct newInstance(Class ifc, List fields, Map values, List qualifiedName) {
        MDRClassLoader loader = BaseObjectHandler.getDefaultClassLoader();
	Class cl = getStructClass(loader, ifc);

        try {
            Constructor cons = cl.getConstructor(new Class[] {List.class, Map.class, List.class});
            RefStruct struct = (RefStruct) cons.newInstance(new Object[] {fields, values, qualifiedName});

            return struct;
	} catch (NoSuchMethodException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
	} catch (IllegalAccessException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
	} catch (InstantiationException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
	} catch (InvocationTargetException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
	}
    }

    /** Creates new StructHandler */
    protected StructImpl(List fields, Map values, List qualifiedName) {
        this.values = values;
        this.qualifiedName = Collections.unmodifiableList(qualifiedName);
        this.fields = Collections.unmodifiableList(fields);
    }

    // --- handler methods

    protected Object handleGet(String memberName) {
        return refGetValue(memberName);
    }

    // --- implementation of RefStruct interface -------------------------------

    public Object refGetValue(String memberName) {
        if (values.containsKey(memberName)) {
            return values.get(memberName);
        } else {
            throw new DebugException("Wrong item name: " + memberName);
        }
    }
    
    public List refFieldNames() {
        return fields;
    }
    
    public List refTypeName() {
        return this.qualifiedName;
    }

    public int hashCode() {
        return qualifiedName.hashCode() * 37 + values.hashCode();
    }
    
    public boolean equals(Object other) {
        // check whether other is instance of the same structure
        if ((other instanceof RefStruct) && ((RefStruct) other).refTypeName().equals(qualifiedName)) {
            Object key;
            Object value;
            // check whether all field values are same for both objects
            for (Iterator it = values.keySet().iterator(); it.hasNext();) {
                key = it.next();
                value = values.get(key);
                if (value == null) {
                    if (((RefStruct) other).refGetValue((String) key) != null)
                        return false;
                } else if (!value.equals(((RefStruct) other).refGetValue((String) key)))
                    return false;
            }
            return true;
        } else {
            return false;
        }
    }
}
