/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers;

import org.netbeans.mdr.util.ImplGenerator;

import java.io.*;
import java.lang.reflect.Method;
import java.util.*;

/**
 *
 * @author Martin Matula
 * @version 
 */
public class StructGenerator extends ImplGenerator {
    private static final String GET_PREFIX = "get"; //NOI18N
    private static final String IS_PREFIX = "is"; //NOI18N

    private static final String M_GET_NAME = "handleGet"; //NOI18N
    private static final String M_GET_DESC = "(Ljava/lang/String;)Ljava/lang/Object;"; //NOI18N

    private static final String CONSTRUCTOR_DESCRIPTOR = "(Ljava/util/List;Ljava/util/Map;Ljava/util/List;)V"; //NOI18N

    private StructGenerator(String className, Class ifc) {
        super(className, ifc, StructImpl.class);
    }

    public static byte[] generateStruct(final String name, Class ifc) {
	StructGenerator gen = new StructGenerator(name, ifc);
	final byte[] classFile = gen.generateClassFile();

	return classFile;
    }

    protected Method[] getMethodsToImplement() {
        Method ifcMethods[] = ifc.getMethods();
        Method objMethods[] = javax.jmi.reflect.RefStruct.class.getMethods();
        HashSet excludeMethods = new HashSet();
        ArrayList methodsToImplement = new ArrayList();
        
        for (int i = 0; i < objMethods.length; i++) {
            excludeMethods.add(objMethods[i].getName() + getMethodDescriptor(objMethods[i].getParameterTypes(), objMethods[i].getReturnType()));
        }
        
        for (int i = 0; i < ifcMethods.length; i++) {
            if (!excludeMethods.contains(ifcMethods[i].getName() + getMethodDescriptor(ifcMethods[i].getParameterTypes(), ifcMethods[i].getReturnType()))) {
                methodsToImplement.add(ifcMethods[i]);
            }
        }
        
        return (Method[]) methodsToImplement.toArray(new Method[methodsToImplement.size()]);
    }
    
    /**
     * Generate the constructor method for the proxy class.
     */
    protected MethodInfo generateConstructor() throws IOException {
	MethodInfo minfo = new MethodInfo(
	    "<init>", CONSTRUCTOR_DESCRIPTOR, //NOI18N
	    ACC_PUBLIC);

	DataOutputStream out = new DataOutputStream(minfo.code);

        // this
	code_aload(0, out);
        // list containing field names
        code_aload(1, out);
        // map containing fields and their values
        code_aload(2, out);
        // type qualified name
        code_aload(3, out);

        // just call super.<init>(String);
	out.writeByte(opc_invokespecial);
	out.writeShort(cp.getMethodRef(
	    dotToSlash(superclass.getName()),
	    "<init>", CONSTRUCTOR_DESCRIPTOR)); //NOI18N

	out.writeByte(opc_return);

	minfo.maxStack = 10;
	minfo.maxLocals = 4;
	minfo.declaredExceptions = new short[0];

	return minfo;
    }

    protected ClassMethod getClassMethod(Method method, Class fromClass) {
        String methodName = method.getName();
        ClassMethod am;

        if (methodName.startsWith(GET_PREFIX)) {
            am = new ClassMethod(method, cp.getMethodRef(dotToSlash(superclass.getName()), M_GET_NAME, M_GET_DESC), firstLower(strip(methodName, GET_PREFIX)));
        } else if (methodName.startsWith(IS_PREFIX)) {
            am = new ClassMethod(method, cp.getMethodRef(dotToSlash(superclass.getName()), M_GET_NAME, M_GET_DESC), firstLower(methodName));
        } else {
            am = super.getClassMethod(method, fromClass);
        }

        return am;
    }
}
