/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.handlers;

import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;
import javax.jmi.reflect.InvalidNameException;
import javax.jmi.reflect.RefEnum;
import java.lang.reflect.Field;
import java.util.Hashtable;

/**
 *
 * @author Martin Matula
 */
public final class EnumResolver  {
    private static final String ENUMIMPL_SUFFIX = "Enum";
    private static final Hashtable enumCache = new Hashtable(50);

    /** Returns a correct instance of an enumeration class representing the requested literal
     * @param ifcName Name of JMI interface generated for the enumeration.
     * @param label Name of the requested literal.
     * @return Instance of an enumeration class representing the literal.
     */
    public static synchronized RefEnum resolveEnum(String ifcName, String label) {
        String enumKey = label + ":" + ifcName;
        RefEnum en = (RefEnum) enumCache.get(enumKey);
        
        if (en == null) {
            try {
                Class cl = BaseObjectHandler.resolveInterface(ifcName + ENUMIMPL_SUFFIX);
                Field f = cl.getField(org.netbeans.mdr.handlers.gen.TagSupport.mapEnumLiteral(label));
                en = (RefEnum) f.get(null);
                enumCache.put(enumKey, en);
            } catch (NoSuchFieldException e) {
                throw new InvalidNameException(label, "Invalid literal name '" + label + "' for enumeration " + ifcName);
            } catch (Exception e) {
                throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
            }
        }
        
        return en;
    }
    
}
