/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.handlers;

import java.util.*;

import javax.jmi.model.*;
import javax.jmi.reflect.*;

import org.netbeans.api.mdr.events.*;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.storagemodel.*;
import org.netbeans.mdr.persistence.StorageException;

/** Invocation handler for ClassProxies
 *
 * @author Petr Hrebejk, Martin Matula
 */
public abstract class ClassProxyHandler extends FeaturedHandler implements RefClass {

    /* -------------------------------------------------------------------- */
    /* -- Constructor ----------------------------------------------------- */
    /* -------------------------------------------------------------------- */

    protected ClassProxyHandler(StorableClass storable) {
        super(storable);
    }

    /* -------------------------------------------------------------------- */
    /* -- Helper methods -------------------------------------------------- */
    /* -------------------------------------------------------------------- */

    private StorableClass getClassDelegate() {
        return (StorableClass) _getDelegate();
    }
    
    /* -------------------------------------------------------------------- */
    /* -- Methods to be called by generated handlers (_pre, _handle, _post) */
    /* -------------------------------------------------------------------- */
    
    protected final Object _preCreate(Object params[]) {
        boolean fail = true;
        _lock(true);
        try {
            if (_getMdrStorage().eventsEnabled()) {
                CreateInstanceEvent event = new CreateInstanceEvent(
                    params == null ? null : new ImmutableList(params)
                );
                _getMdrStorage().getEventNotifier().CLASS.firePlannedChange(this, event);
                fail = false;
                return event;
            }
            fail = false;
            return null;
        } finally {
            if (fail) _unlock(true);
        }
    }

    protected final RefObject _handleCreate(Object params[]) {
        try {
            if (getClassDelegate().isSingleton()) {
                Iterator it = refAllOfClass().iterator();
                if (it.hasNext()) {
                    throw new AlreadyExistsException((RefObject) it.next());
                }
            }
            if (params == null) {
                params = new Object[getClassDelegate().getAttrCount()];
            }
            StorableObject storableObject;
            if (getClassDelegate ().isTransient ()) {
                storableObject = new TransientStorableObject (getClassDelegate().getMdrStorage(), _getDelegate().getImmediatePackageId(), _getDelegate().getMetaObjectId(), _getDelegate().getMofId(), params);
            }
            else {
                storableObject = new StorableObject(getClassDelegate().getMdrStorage(), _getDelegate().getImmediatePackageId(), _getDelegate().getMetaObjectId(), _getDelegate().getMofId(), params);
            }
            return (RefObject) _getRepository().getHandler (storableObject);
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    protected final void _postCreate(RefObject result, Object extraInfo, boolean fail) {
        if (extraInfo != null) {
            CreateInstanceEvent event = (CreateInstanceEvent) extraInfo;
            event.setInstance(result);
        }
        _unlock(fail);
    }
    
    protected final Object _preEnum(String enumName, String literal) {
        _lock(false);
        return null;
    }
    
    protected final RefEnum _handleEnum(String enumName, String literal) {
        return EnumResolver.resolveEnum(getClassDelegate().getDatatypeDesc(enumName).getIfcName(), literal);
    }
    
    protected final void _postEnum(RefEnum result, Object extraInfo, boolean fail) {
        _unlock();
    }
    
    protected final Object _preStruct(String structName, Object fieldValues[]) {
        _lock(false);
        return null;
    }

    protected final RefStruct _handleStruct(String structName, Object fieldValues[]) {
        return StructImpl.newInstance(getClassDelegate().getDatatypeDesc(structName), fieldValues);
    }

    protected final void _postStruct(RefStruct result, Object extraInfo, boolean fail) {
        _unlock();
    }
    
    protected final Object _handleGet(String attrName) {
        Object result;
        
        try {
            result = getClassDelegate().getAttribute(attrName);
            if (result instanceof Collection) {
                if (result instanceof AttrList) {
                    result = new AttrListWrapper(this, 0, attrName);
                } else if (result instanceof AttrCollection) {
                    result = new AttrCollWrapper(this, 0, attrName);
                } else if (result instanceof AttrImmutList) {
                    result = new AttrImmutListWrapper(_getMdrStorage(), this, 0, attrName);
                }
            }
            return result;
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    protected final void _handleSet(String attrName, Object newValue) {
        try {
            getClassDelegate().setAttribute(attrName, newValue);
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }

    /* -------------------------------------------------------------------- */
    /* -- Implementation of javax.jmi.reflect.RefClass -------------------- */
    /* -------------------------------------------------------------------- */

    public final Collection refAllOfType() {
        try {
            _lock(false);
            return _allOfClass(true);
        } finally {
            _unlock();
        }
    }
    
    public final Collection refAllOfClass() {
        try {
            _lock(false);
            return _allOfClass(false);
        } finally {
            _unlock();
        }
    }
    
    protected Collection _allOfClass(boolean includeSubtypes) {
        try {
            return new IndexSetWrapper(_getMdrStorage(), getClassDelegate().allObjects(includeSubtypes));
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }

    public final RefObject refCreateInstance(List args) {
        Object params[] = (args == null ? null : args.toArray());
        return _createInstance(params);
    }

    public final RefEnum refGetEnum(String enumName, java.lang.String name) {
        boolean fail = true;
        Object extraInfo = null;
        RefEnum result = null;
        try {
            extraInfo = _preEnum(enumName, name);
            result = _handleEnum(enumName, name);
            fail = false;
            return result;
        } catch (NullPointerException e) {
            throw new InvalidNameException(enumName);
        } finally {
            _postEnum(result, extraInfo, fail);
        }
    }
    
    public final RefEnum refGetEnum(RefObject en, String name) {
        EnumerationType et;
        try {
            et = (EnumerationType) en;
        } catch (ClassCastException e) {
            throw new InvalidCallException(this, en, "Invalid enumeration designator: " + en);
        }
        try {
            return refGetEnum(et.getName(), name);
        } catch (InvalidNameException e) {
            throw new InvalidCallException(this, en);
        }
    }

    public final RefStruct refCreateStruct(String structName, java.util.List params) {
        Object args[] = params.toArray();
        return _createStruct(structName, args);
    }
    
    public final RefStruct refCreateStruct(RefObject struct, List params) {
        StructureType st;
        try {
            st = (StructureType) struct;
        } catch (ClassCastException e) {
            throw new InvalidCallException(this, struct, "Invalid structure designator: " + struct);
        }
        try {
            return refCreateStruct(st.getName(), params);
        } catch (InvalidNameException e) {
            throw new InvalidCallException(this, struct);
        }
    }
    
    /* ----------------------------------------------------------- */
    /* -- methods to be implemented by generated handlers -------- */
    /* ----------------------------------------------------------- */

    public RefObject _createInstance(Object[] params) {
        throw new InvalidCallException(this, null, "Cannot create instance of an abstract class.");
    }

    public abstract RefStruct _createStruct(String structName, Object[] params);
    
    /* -------------------------------------------------------------------- */
    /* -- Implementation of org.netbeans.api.mdr.events.MDRChangeSource --- */
    /* -------------------------------------------------------------------- */
    
    /** Registers a listener for receiving all event notifications
     *  fired on this object.
     * @param listener Object that implements {@link MDRChangeListener} interface.
     */
    public void addListener(MDRChangeListener listener) {
        addListener(listener, MDRChangeEvent.EVENTMASK_ALL);
    }
    
    /** Registers a listener for receiving event notifications.
     * @param listener Object that implements {@link MDRChangeListener} interface.
     * @param mask bitmask to filter types of events the listener listens on
     */
    public void addListener(MDRChangeListener listener, int mask) {
        _getMdrStorage().getEventNotifier().CLASS.addListener(listener, mask, this);
    }
    
    /** Removes listener from the list of objects registered for event notifications.
     * @param listener Object that implements {@link MDRChangeListener} interface.
     */
    public void removeListener(MDRChangeListener listener) {
        _getMdrStorage().getEventNotifier().CLASS.removeListener(listener, this);
    }
    
    /** Removes listener from the list of objects registered for event notifications.
     * @param listener Object that implements {@link MDRChangeListener} interface.
     * @param mask determines type of the events the listeners stops to listen on
     */
    public void removeListener(MDRChangeListener listener, int mask) {
        _getMdrStorage().getEventNotifier().CLASS.removeListener(listener, mask, this);
    }
    
    /* -------------------------------------------------------------------- */
    /* -- ClassProxyHandler.CreateInstanceEvent (inner class) ------------- */
    /* -------------------------------------------------------------------- */
    
    private class CreateInstanceEvent extends InstanceEvent {
        CreateInstanceEvent(List params) {
            super(ClassProxyHandler.this, EVENT_INSTANCE_CREATE, params, null);
        }
        
        void setInstance(RefObject instance) {
            this.instance = instance;
        }
    }

    /* ---------------------------------------------------------------- */
    /* -- Implementation of abstract methods from BaseObjectHandler --- */
    /* ---------------------------------------------------------------- */

    protected final Collection _recursiveVerify(Collection violations, Set visited) {
        _lock(false);
        try {
            _verify(violations);
            visited.add(this);
            for (Iterator it = refAllOfClass().iterator(); it.hasNext();) {
                InstanceHandler obj = (InstanceHandler) it.next();
                if (!visited.contains(obj)) obj._recursiveVerify(violations, visited);
            }
            return violations;
        } finally {
            _unlock();
        }
    }    

    protected Collection _verify(Collection violations) {
        _lock(false);
        try {
            getClassDelegate().verify(violations);
            return violations;
        } finally {
            _unlock();
        }
    }
}
