/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.handlers;

/**
 * @author Martin Matula
 */
public interface ClassLoaderProvider {
    /** Implementation of this method should return a classloader that MDR will use
     * for resolving JMI interfaces/classes and classes that implement derived
     * attributes and operations.
     * @return classloader
     */
    public ClassLoader getClassLoader();
    
    /** Implementation of this method can define a given class.
     * The defined class should be then visible from the ClassLoader returned
     * from {@link #getClassLoader} method.
     * @param className name of the class to define.
     * @param classFile array of bytes representing the class.
     * @return Defined class or null (if null is return, MDR will define the
     * class in its own classloader. This class will then not be accessible from outside
     * of MDR
     * @throws ClassFormatError
     */
    public Class defineClass(String className, byte[] classFile);
}
