/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers;

import java.lang.ref.WeakReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;

import org.netbeans.mdr.storagemodel.AssociationLink;

import javax.jmi.reflect.RefAssociationLink;
import javax.jmi.reflect.RefObject;
import org.netbeans.mdr.storagemodel.StorableObject;

/**
 *
 * @author Martin Matula
 */
class AssociationLinkWrapper implements RefAssociationLink {
    private static final IdentityCache identityCache = new IdentityCache();

    private final AssociationLink innerLink;
    
    /** Creates new AssociationLinkWrapper */
    private AssociationLinkWrapper(AssociationLink innerLink) {
        this.innerLink = innerLink;
    }
    
    AssociationLink getInnerLink() {
        return innerLink;
    }

    public RefObject refFirstEnd() {
        StorableObject fe = innerLink.getFirstEnd();
        return (RefObject) fe.getMdrStorage().getRepository().getHandler(fe);
    }
    
    public RefObject refSecondEnd() {
        StorableObject se = innerLink.getSecondEnd();
        return (RefObject) se.getMdrStorage().getRepository().getHandler(se);
    }
    
    public boolean equals(Object other) {
        if (other instanceof AssociationLinkWrapper) {
            return this == other;
        } else return (other instanceof RefAssociationLink) && 
            ((RefAssociationLink) other).refFirstEnd().equals(refFirstEnd()) && 
            ((RefAssociationLink) other).refSecondEnd().equals(refSecondEnd());
    }
    
    public int hashCode() {
        return (innerLink.getFirstEnd().getMofId().toString() + innerLink.getSecondEnd().getMofId().toString()).hashCode();
    }

    static RefAssociationLink wrapLink(AssociationLink innerLink) {
        if (innerLink == null) {
            return null;
        }
        
        String linkID = innerLink.getFirstEnd().getMofId().toString() + ":" + innerLink.getSecondEnd().getMofId().toString();
        
        synchronized (identityCache) {
            RefAssociationLink result = (RefAssociationLink) identityCache.get(linkID);
            if (result == null) {
                result = new AssociationLinkWrapper(innerLink);
                identityCache.put(linkID, result);
            }
            return result;
        }
    }

    private static class IdentityCache extends HashMap {
        private final ReferenceQueue queue = new ReferenceQueue();

        private class LinkReference extends WeakReference {
            private String mofId;

            public LinkReference(String key, RefAssociationLink link) {
                super(link, queue);

                mofId = key;
            }

            public String getProxyMofId() {
                return mofId;
            }
        }

        private void cleanUp() {
            LinkReference reference;

            while ((reference = (LinkReference) queue.poll()) != null) {
//                Logger.getDefault().log("Removing: " + reference.getProxyMofId());
                this.remove(reference.getProxyMofId());
            }
        }
        
        public Object put(Object key, Object value) {
            cleanUp();
            Object result = super.put(key, new LinkReference((String) key, (RefAssociationLink) value));
            if (result != null) {
                return ((LinkReference) result).get();
            } else {
                return result;
            }
        }

        public Object get(Object key) {
            cleanUp();
            Object result = super.get(key);
            if (result != null) {
                return ((LinkReference) result).get();
            } else {
                return result;
            }
        }
    }
}
