/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers;

import java.util.*;
import javax.jmi.model.*;
import javax.jmi.reflect.*;

import org.netbeans.api.mdr.*;
import org.netbeans.api.mdr.events.*;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.storagemodel.*;
import org.netbeans.mdr.persistence.StorageException;

/** Invocation handler for Associations
 *
 * @author Petr Hrebejk, Martin Matula
 * @version
 */
public abstract class AssociationHandler extends BaseObjectHandler implements RefAssociation {

    /* -------------------------------------------------------------------- */
    /* -- Constructor ----------------------------------------------------- */
    /* -------------------------------------------------------------------- */

    /** Creates new AssociationProxy */
    protected AssociationHandler(StorableAssociation storable) {
        super(storable);
    }

    /* -------------------------------------------------------------------- */
    /* -- Helper methods -------------------------------------------------- */
    /* -------------------------------------------------------------------- */

    private StorableAssociation getAssociationDelegate() {
        return (StorableAssociation) _getDelegate();
    }

    /* -------------------------------------------------------------------- */
    /* -- Methods to be called by generated handlers (_pre, _handle, _post) */
    /* -------------------------------------------------------------------- */

    /**
     * Executed before allLinks operation of the underlying object gets called.
     * @return additional information which will be passed to the _postAllLinks method (can be <code>null</code>)
     */
    protected final Object _preAllLinks() {
        _lock(false);
        return null;
    }
    
    protected final java.util.Collection _handleAllLinks() {
        try {
            return new IndexSetWrapper(_getMdrStorage(), getAssociationDelegate().getAllLinks());
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    /** Executed after the allLinks operation was called.
     * @param result Result of allLinks operation
     * @param extraInfo additional information created by {@link #_preAllLinks} method
     */
    protected final void _postAllLinks(java.util.Collection result, Object extraInfo, boolean fail) {
        _unlock();
    }
    
    protected final Object _preExists(RefObject associationEnd1, RefObject associationEnd2) {
        _lock(false);
        return null;
    }
    
    protected final Boolean _handleExists(RefObject associationEnd1, RefObject associationEnd2) {
        try {
            return getAssociationDelegate().linkExists(((BaseObjectHandler)associationEnd1)._getDelegate().getMofId(), ((BaseObjectHandler)associationEnd2)._getDelegate().getMofId()) ? Boolean.TRUE : Boolean.FALSE;
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    protected final void _postExists(Boolean result, Object extraInfo, boolean fail) {
        _unlock();
    }
    
    protected final Object _preQuery(String endName, RefObject query) {
        _lock(false);
        return null;
    }

    public final Object _handleQuery(String endName, RefObject query) {
        Object result;
        
        try {
            result = getAssociationDelegate().queryObjects(endName, query == null ? null : ((BaseObjectHandler)query)._getDelegate().getMofId());
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
        
        if (result instanceof AssocEndIndexUList) {
            return new AEIndexUListWrapper(this, query, endName, (AssocEndIndexUList) result, getAssociationDelegate().getEnd1Name().equals(endName));
        } else if (result instanceof AssocEndIndexSet) {
            return new AEIndexSetWrapper(this, query, endName, (AssocEndIndexSet) result, getAssociationDelegate().getEnd1Name().equals(endName));
        } else {
            return _getRepository().getHandler((StorableBaseObject) result);
        }
    }
    
    protected final void _postQuery(Object result, Object extraInfo, boolean fail) {
        _unlock();
    }
    
    protected final Object _preAdd(RefObject associationEnd1, RefObject associationEnd2) {
        boolean fail = true;
        _lock(true);
        try {
            if (_getMdrStorage().eventsEnabled()) {
                AssociationEvent event = new AssociationEvent(
                this,
                AssociationEvent.EVENT_ASSOCIATION_ADD,
                associationEnd1,
                getAssociationDelegate().getEnd1Name(),
                null,
                associationEnd2,
                AssociationEvent.POSITION_NONE
                );
                _getMdrStorage().getEventNotifier().ASSOCIATION.firePlannedChange(this, event);
                fail = false;
                return event;
            }
            fail = false;
            return null;
        } finally {
            if (fail) _unlock(true);
        }
    }
    
    protected final Boolean _handleAdd(RefObject associationEnd1, RefObject associationEnd2) {
        try {
            Boolean result = _handleLocalAdd(associationEnd1, associationEnd2);
            if (!associationEnd1.refOutermostPackage().equals(associationEnd2.refOutermostPackage())) {
                _addExternalLink(this, associationEnd1, associationEnd2);
            }
            return result;
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    protected final Boolean _handleLocalAdd(RefObject associationEnd1, RefObject associationEnd2) throws StorageException {
        return getAssociationDelegate().addLink(((BaseObjectHandler)associationEnd1)._getDelegate().getMofId(), ((BaseObjectHandler)associationEnd2)._getDelegate().getMofId()) ? Boolean.TRUE : Boolean.FALSE;
    }
    
    protected final void _postAdd(Boolean result, Object extraInfo, boolean fail) {
        _unlock(fail);
    }
    
    protected final Object _preRemove(RefObject associationEnd1, RefObject associationEnd2) {
        boolean fail = true;
        _lock(true);
        try {
            if (_getMdrStorage().eventsEnabled()) {
                AssociationEvent event = new AssociationEvent(
                this,
                AssociationEvent.EVENT_ASSOCIATION_REMOVE,
                associationEnd1,
                getAssociationDelegate().getEnd1Name(),
                associationEnd2,
                null,
                AssociationEvent.POSITION_NONE
                );
                _getMdrStorage().getEventNotifier().ASSOCIATION.firePlannedChange(this, event);
                fail = false;
                return event;
            }
            fail = false;
            return null;
        } finally {
            if (fail) _unlock(true);
        }
    }
    
    protected final Boolean _handleRemove(RefObject associationEnd1, RefObject associationEnd2) {
        try {
            Boolean result = _handleLocalRemove(associationEnd1, associationEnd2);
            if (!associationEnd1.refOutermostPackage().equals (associationEnd2.refOutermostPackage())) {
                _removeExternalLink(this, associationEnd1, associationEnd2);
            }
            return result;
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    protected final Boolean _handleLocalRemove(RefObject associationEnd1, RefObject associationEnd2) throws StorageException {
        return getAssociationDelegate().removeLink(((BaseObjectHandler)associationEnd1)._getDelegate().getMofId(), ((BaseObjectHandler)associationEnd2)._getDelegate().getMofId()) ? Boolean.TRUE : Boolean.FALSE;
    }
    
    protected final void _postRemove(Boolean result, Object extraInfo, boolean fail) {
        _unlock(fail);
    }

    /* -------------------------------------------------------------------- */
    /* -- Implementation of javax.jmi.reflect.RefAssociation -------------- */
    /* -------------------------------------------------------------------- */

    public final boolean refRemoveLink(RefObject firstEnd, RefObject secondEnd) {
        try {
            return _remove(firstEnd, secondEnd);
        } catch (ClassCastException e) {
            // this will throw TypeMismatchException or DebugException if the mismatch is not found
            getAssociationDelegate().checkType(firstEnd, secondEnd);
            // this is here only to make the compiler happy
            return false;
        }
    }
    
    public final boolean refAddLink(RefObject firstEnd, RefObject secondEnd) {
        try {
            return _add(firstEnd, secondEnd);
        } catch (ClassCastException e) {
            // this will throw TypeMismatchException or DebugException if the mismatch is not found
            getAssociationDelegate().checkType(firstEnd, secondEnd);
            // this is here only to make the compiler happy
            return false;
        }
    }
    
    public final Collection refQuery(RefObject queryEnd, RefObject queryObject) {
        try {
            return refQuery(((AssociationEnd) queryEnd).getName(), queryObject);
        } catch (InvalidNameException e) {
            throw new InvalidCallException(null, queryEnd);
        } catch (ClassCastException e) {
            throw new InvalidCallException(null, queryEnd);
        }
    }
    
    public final Collection refQuery(String endName, RefObject queryObject) {
        Object result;
        try {
            result = _query(endName, queryObject);
        } catch (ClassCastException e) {
            // this will throw TypeMismatchException or DebugException if the mismatch is not found
            if (getAssociationDelegate().getEnd1Name().equals(endName)) {
                getAssociationDelegate().checkType(queryObject, null);
            } else {
                getAssociationDelegate().checkType(null, queryObject);
            }                
            // this is here only to make the compiler happy
            return null;
        }
        Collection col;
        if (result instanceof Collection) {
            return (Collection) result;
        }
        if (result == null) {
            return new ArrayList(0);
        }
        col = new ArrayList(1);
        col.add(result);
        return col;
    }
    
    public final boolean refLinkExists(RefObject firstEnd, RefObject secondEnd) {
        try {
            return _exists(firstEnd, secondEnd);
        } catch (ClassCastException e) {
            // this will throw TypeMismatchException or DebugException if the mismatch is not found
            getAssociationDelegate().checkType(firstEnd, secondEnd);
            // this is here only to make the compiler happy
            return false;
        }
    }

    /* -------------------------------------------------------------------- */
    /* -- abstract methods to be implemented by generated handlers -------- */
    /* -------------------------------------------------------------------- */

    public abstract boolean _add(RefObject end1, RefObject end2);
    public abstract boolean _remove(RefObject end1, RefObject end2);
    public abstract Object _query(String endName, RefObject end);
    public abstract boolean _exists(RefObject end1, RefObject end2);
    public abstract Collection _all();
    
    // derived associations must override this method if one of the association ends
    // is single-valued!
    /*
    public void replace(RefObject oldEnd1, RefObject oldEnd2, RefObject newEnd1, RefObject newEnd2) {
    }

    /* -------------------------------------------------------------------- */
    /* -- Implementation of org.netbeans.api.mdr.events.MDRChangeSource --- */
    /* -------------------------------------------------------------------- */
    
    /** Registers a listener for receiving all event notifications
     *  fired on this object.
     * @param listener Object that implements {@link MDRChangeListener} interface.
     */
    public void addListener(MDRChangeListener listener) {
        addListener(listener, MDRChangeEvent.EVENTMASK_ALL);
    }
    
    /** Registers a listener for receiving event notifications.
     * @param listener Object that implements {@link MDRChangeListener} interface.
     * @param mask bitmask to filter types of events the listener listens on
     */
    public void addListener(MDRChangeListener listener, int mask) {
        _getMdrStorage().getEventNotifier().ASSOCIATION.addListener(listener, mask, this);
    }
    
    /** Removes listener from the list of objects registered for event notifications.
     * @param listener Object that implements {@link MDRChangeListener} interface.
     */
    public void removeListener(MDRChangeListener listener) {
        _getMdrStorage().getEventNotifier().ASSOCIATION.removeListener(listener, this);
    }
    
    /** Removes listener from the list of objects registered for event notifications.
     * @param listener Object that implements {@link MDRChangeListener} interface.
     * @param mask determines type of the events the listeners stops to listen on
     */
    public void removeListener(MDRChangeListener listener, int mask) {
        _getMdrStorage().getEventNotifier().ASSOCIATION.removeListener(listener, mask, this);
    }

    /* --------------------------------------------------------------------- */
    /* --        -- */
    /* --------------------------------------------------------------------- */
    
    static void _removeExternalLink(AssociationHandler associationHandler, RefObject thisEnd, RefObject otherEnd) {
        if (MdrStorage.isTransientMofId (((BaseObjectHandler)thisEnd)._getDelegate().getMofId ()) || MdrStorage.isTransientMofId (((BaseObjectHandler)otherEnd)._getDelegate().getMofId ()))
            return;
        RefPackage oeip = null;
        if (thisEnd.refOutermostPackage().equals(associationHandler.refOutermostPackage()))
            oeip = otherEnd.refOutermostPackage();
        else
            oeip = thisEnd.refOutermostPackage();
        
        String name = ((javax.jmi.model.Association)associationHandler.refMetaObject()).getName();
        RefAssociation oea = _findAssociation(oeip, name);
        if (oea instanceof AssociationHandler) {
            boolean failed = true;
            Boolean result = null;
            try {
                ((AssociationHandler)oea)._preRemove (thisEnd, otherEnd);
                result = ((AssociationHandler)oea)._handleLocalRemove(thisEnd, otherEnd);
                failed = false;
            }catch (Exception e) {
            }
            finally {
                ((AssociationHandler)oea)._postRemove (result, null, failed);
            }
        }
    }
    
    static void _addExternalLink(AssociationHandler associationHandler, RefObject thisEnd, RefObject otherEnd) {
        if (MdrStorage.isTransientMofId (((BaseObjectHandler)thisEnd)._getDelegate().getMofId ()) || MdrStorage.isTransientMofId (((BaseObjectHandler)otherEnd)._getDelegate().getMofId ()))
            return;
        RefPackage oeip = null;
        if (thisEnd.refOutermostPackage().equals(associationHandler.refOutermostPackage()))
            oeip = otherEnd.refOutermostPackage();
        else
            oeip = thisEnd.refOutermostPackage ();
        String name = ((javax.jmi.model.Association)associationHandler.refMetaObject()).getName();
        RefAssociation oea = _findAssociation (oeip, name);
        if (oea instanceof AssociationHandler) {
            boolean failed = true;
            Boolean result = null;
            try {
                ((AssociationHandler)oea)._preAdd (thisEnd, otherEnd);
                result = ((AssociationHandler)oea)._handleLocalAdd(thisEnd, otherEnd);
                failed = false;
            }catch (Exception e) {}
            finally {
                ((AssociationHandler)oea)._postAdd (result, null, failed);
            }
        }
    }
    
    // [PENDING] (MaM) This is wrong! Method needs to use FQN to find the association
    private static RefAssociation _findAssociation (RefPackage opkg, String name) {
        ArrayList list = new ArrayList ();
        list.add (opkg);
        while (!list.isEmpty()) {
            RefPackage pkg = (RefPackage) list.remove (0);
            try {
                RefAssociation oea = pkg.refAssociation (name);
                return oea;
            } catch (javax.jmi.reflect.InvalidNameException invalidName) {
            }
            Object innerPackages = pkg.refAllPackages();
            if (innerPackages instanceof RefPackage) {
                list.add (innerPackages);
            }
            else {
                list.addAll ((Collection)innerPackages);
            }
        }
        return null;
    }
    
    /* ---------------------------------------------------------------- */
    /* -- Implementation of abstract methods from BaseObjectHandler --- */
    /* ---------------------------------------------------------------- */

    protected final Collection _recursiveVerify(Collection violations, Set visited) {
        _lock(false);
        try {
            _verify(violations);
            visited.add(this);
            return violations;
        } finally {
            _unlock();
        }
    }    

    protected Collection _verify(Collection violations) {
        _lock(false);
        try {
            getAssociationDelegate().verify(violations);
            return violations;
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        } finally {
            _unlock();
        }
    }
    
    /* -------------------------------------------------------------------- */
    /* -- AssociationHandler.RefAssociationLinkImpl (inner class) --------- */
    /* -------------------------------------------------------------------- */
    
    static class RefAssociationLinkImpl implements RefAssociationLink {
        private final RefObject firstEnd;
        private final RefObject secondEnd;
        
        RefAssociationLinkImpl(RefObject firstEnd, RefObject secondEnd) {
            this.firstEnd = firstEnd;
            this.secondEnd = secondEnd;
        }
        
        public RefObject refFirstEnd() {
            return firstEnd;
        }
        
        public RefObject refSecondEnd() {
            return secondEnd;
        }
    }
}
