/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmiimpl.mof.model;

import java.util.*;
import javax.jmi.model.*;
import javax.jmi.reflect.*;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.storagemodel.*;
import org.netbeans.mdr.persistence.*;
import org.netbeans.mdr.handlers.*;

/**
 * Implements MOF operations
 *
 * @author mmatula
 */
public abstract class NamespaceImpl extends ModelElementImpl implements Namespace {

    protected NamespaceImpl(StorableObject storable) {
        super(storable);
    }

    private static final HashMap contains = new HashMap();

    public static void clearContains() {
        contains.clear();
    }

    protected static StorableAssociation resolveContains(StorableFeatured storable) throws StorageException {
        StorableAssociation result = (StorableAssociation) contains.get(storable.getOutermostPackageId());

        if (result == null) {
            result = storable.getClassProxy().getReferenceDescriptor(MOFConstants.SH_MODEL_MODEL_ELEMENT_CONTAINER).getAssociation();
            contains.put(storable.getOutermostPackageId(), result);
        }

        return result;
    }

    // --- operations

    public ModelElement lookupElement(String name) throws NameNotFoundException {
        _lock(false);
        try {
            Collection contents;

    //        StorableFeatured storable = (StorableFeatured) _getDelegate();
    //        Collection items = storable.getMdrStorage().objectsFromAdditionalIndex(storable.getOutermostPackageId(), "ModelElement.name", name);
    //
    //        if (items != null) {
    //            try {
    //                StorableAssociation assoc = resolveContains(storable);
    //                contents = (Collection) assoc.queryObjects(assoc.getEnd1Name(), storable.getMofId());
    //            } catch (StorageException e) {
    //                throw Logger.getDefault().annotate(new DebugException(), e);
    //            }
    //            Object result;
    //            for (Iterator it = items.iterator(); it.hasNext();) {
    //                result = it.next();
    //                if (contents.contains(result)) {
    //                    return (ModelElement) BaseObjectHandler.getHandler((StorableBaseObject) result);
    //                }
    //            }
    //        } else {
                contents = getContents();

                for(Iterator it = contents.iterator(); it.hasNext();) {
                    ModelElement el = (ModelElement) it.next();
                    if (el.getName().equals(name)) {
                        return el;
                    }
                }
    //        }
        } finally {
            _unlock();
        }

        throw new NameNotFoundException(name);
    }

    public ModelElement resolveQualifiedName(List qualifiedName) throws NameNotResolvedException {
        if (qualifiedName.size() < 1) {
            throw new DebugException("No qualified name provided.");
        }
        
        ModelElement element;
        Iterator qnIterator = qualifiedName.iterator();
        String name = (String) qnIterator.next();
        ArrayList rest = new ArrayList();

        _lock(false);
        try {
            try {
                element = lookupElement(name);
            } catch (NameNotFoundException e) {
                throw new NameNotResolvedException("InvalidName", qualifiedName);
            }

            for (; qnIterator.hasNext();) {
                rest.add(qnIterator.next());
            }

            if (rest.size() >= 1) {
                if (element instanceof Namespace) {
                    element = ((Namespace) element).resolveQualifiedName(rest);
                } else {
                    throw new NameNotResolvedException("NotNameSpace", qualifiedName);
                }
            }
        } finally {
            _unlock();
        }

        return element;
    }

    public boolean nameIsValid(String proposedName) {
        _lock(false);
        try {
            if (this instanceof GeneralizableElement) {
                ((GeneralizableElement) this).lookupElementExtended(proposedName);
            } else {
                this.lookupElement(proposedName);
            }
            return false;
        } catch (NameNotFoundException e) {
            return true;
        } finally {
            _unlock();
        }
   }

    public List findElementsByType(javax.jmi.model.MofClass ofType, boolean includeSubtypes ) {
        _lock(false);
        try {
            ArrayList result = new ArrayList();
            Collection contents = getContents();
            RefObject element;

            for (Iterator it = contents.iterator(); it.hasNext();) {
                element = (RefObject) it.next();
                if (element.refIsInstanceOf(ofType, includeSubtypes)) {
                    result.add(element);
                }
            }

            return result;
        } finally {
            _unlock();
        }
    }

    // --- derived attributes

}
