/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmiimpl.mof.model;

import java.util.*;
import javax.jmi.model.*;
import javax.jmi.reflect.*;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.storagemodel.*;
import org.netbeans.mdr.handlers.*;
import org.netbeans.mdr.persistence.StorageException;

/**
 * Implements MOF operations of GeneralizableElement class of MOF model.
 *
 * @author Martin Matula
 */
public abstract class GeneralizableElementImpl extends NamespaceImpl implements GeneralizableElement {

    protected GeneralizableElementImpl(StorableObject storable) {
        super(storable);
    }

    private Collection/*<StorableFeatured>*/ extendedNamespace() {
        try {
            StorableFeatured storable = (StorableFeatured) _getDelegate();
            StorableAssociation assoc = resolveContains(storable);
            Collection result = new ArrayList((Collection) assoc.queryObjects(assoc.getEnd1Name(), storable.getMofId()));

            if (this instanceof GeneralizableElement) {
                Collection supertypes = ((GeneralizableElement) this).allSupertypes();

                for (Iterator it = supertypes.iterator(); it.hasNext();) {
                    storable = (StorableFeatured) ((BaseObjectHandler) it.next())._getDelegate();
                    result.addAll((Collection) assoc.queryObjects(assoc.getEnd1Name(), storable.getMofId()));
                }
            }

            if (this instanceof MofPackage) {
                ArrayList imports = new ArrayList();
                Object temp;

                for (Iterator it = result.iterator(); it.hasNext();) {
                    temp = it.next();
                    if (temp instanceof Import) {
                        imports.add(((BaseObjectHandler) ((Import) temp).getImportedNamespace())._getDelegate());
                    }
                }

                result.addAll(imports);
            }

            return result;
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }

    private void allSupertypes2(List result, Set visited) {
        List tempElements = getSupertypes();
        GeneralizableElementImpl element;

        for (Iterator it = tempElements.iterator(); it.hasNext();) {
            element = (GeneralizableElementImpl) it.next();
            if (visited.add(element)) {
                element.allSupertypes2(result, visited);
                result.add(element);
            }
        }
    }

    // --- operations

    public List allSupertypes() {
        _lock(false);
        try {
            List result = new ArrayList();
            allSupertypes2(result, new HashSet());
            return result;
        } finally {
            _unlock();
        }
    }

    public ModelElement lookupElementExtended(String name) throws NameNotFoundException {
        _lock(false);
        try {
            Collection contents = extendedNamespace();
    //        StorableBaseObject storable = _getDelegate();
    //        Collection items = storable.getMdrStorage().objectsFromAdditionalIndex(storable.getOutermostPackageId(), "ModelElement.name", name);
    //
    //        if (items != null) {
    //            Object result;
    //            for (Iterator it = items.iterator(); it.hasNext();) {
    //                result = it.next();
    //                if (contents.contains(result)) {
    //                    return (ModelElement) BaseObjectHandler.getHandler((StorableBaseObject) result);
    //                }
    //            }
    //        } else {
                for (Iterator it = contents.iterator(); it.hasNext();) {
                    ModelElement el = (ModelElement) _getRepository().getHandler((StorableBaseObject) it.next());
                    if (el.getName().equals(name)) {
                        return el;
                    }
                }
    //        }
        } finally {
            _unlock();
        }

        throw new NameNotFoundException(name);
    }

    public List findElementsByTypeExtended(javax.jmi.model.MofClass ofType, boolean includeSubtypes) {
        _lock(false);
        try {
            ArrayList result = new ArrayList();
            RefObject element;
            Collection contents = extendedNamespace();

            for (Iterator it = contents.iterator(); it.hasNext();) {
                element = (RefObject) _getRepository().getHandler((StorableObject) it.next());
                if (element.refIsInstanceOf(ofType, includeSubtypes)) {
                    result.add(element);
                }
            }

            return result;
        } finally {
            _unlock();
        }
    }

    // --- derived attributes

}
