/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmiimpl.mof.model;

import java.util.*;

import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Reference;
import javax.jmi.model.RefersTo;
import javax.jmi.model.Exposes;
import javax.jmi.model.ModelPackage;
import javax.jmi.reflect.*;

import org.netbeans.mdr.handlers.*;
import org.netbeans.mdr.storagemodel.*;

/** Implementation of Exposes association, which is derived in the MOF model.
 *
 * @author Martin Matula
 * @version 
 */
public abstract class ExposesImpl extends AssociationHandler implements Exposes {

    /** Creates new ExposesImpl */
    protected ExposesImpl(StorableAssociation storable) {
        super(storable);
    }

    public Collection refAllLinks() {
        // [PENDING] live collection should be returned
        ModelPackage pkg = (ModelPackage) refImmediatePackage();
        RefersTo assoc = pkg.getRefersTo();
        Collection allLinks = assoc.refAllLinks();
        ArrayList result = new ArrayList(allLinks.size());
        RefAssociationLink link;

        for (Iterator it = allLinks.iterator(); it.hasNext();) {
            link = (RefAssociationLink) it.next();
            result.add(new AssociationLink((StorableObject) ((BaseObjectHandler) link.refFirstEnd())._getDelegate(), (StorableObject) ((BaseObjectHandler) link.refSecondEnd())._getDelegate()));
        }

        return new IndexSetWrapper(_getMdrStorage(), result);
    }

    public boolean exists(Reference referrer, AssociationEnd exposedEnd) {
        return exposedEnd.equals(referrer.getReferencedEnd().otherEnd());
    }

    public AssociationEnd getExposedEnd(Reference referrer) {
        return referrer.getReferencedEnd().otherEnd();
    }

    public Collection getReferrer(AssociationEnd exposedEnd) {
        return ((ModelPackage) refImmediatePackage()).getRefersTo().getReferent(exposedEnd.otherEnd());
    }

    public boolean add(Reference referrer, AssociationEnd exposedEnd) {
        ModelPackage pkg = (ModelPackage) refImmediatePackage();
        RefersTo assoc = (RefersTo) pkg.getRefersTo();
        return assoc.add(referrer, exposedEnd.otherEnd());
    }

    public boolean remove(Reference referrer, AssociationEnd exposedEnd) {
        ModelPackage pkg = (ModelPackage) refImmediatePackage();
        RefersTo assoc = (RefersTo) pkg.getRefersTo();
        return assoc.remove(referrer, exposedEnd.otherEnd());
    }
}
