/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdrshell;

import java.util.*;
import java.io.*;

import koala.dynamicjava.interpreter.*;
import koala.dynamicjava.parser.wrapper.*;

import org.netbeans.api.mdr.MDRManager;
import org.netbeans.mdr.handlers.*;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.memoryimpl.StorageFactoryImpl;
import org.openide.ErrorManager;

/**
 *
 * @author Petr Hrebejk
 * @version 
 */
public class DJava extends Object {

    /** Creates new DJava */
    public DJava() {
    }

    static koala.dynamicjava.interpreter.Interpreter interpreter;
    /**
     * Initialize the engine.
     */
    public static void initialize ( ) {
        // create an interpreter
        interpreter = new TreeInterpreter(new JavaCCParserFactory());
        BaseObjectHandler.setClassLoaderProvider(new CLProviderImpl());

        // this is here just to make MDR boot when starting up the shell (not lazily)
        MDRManager.getDefault().getDefaultRepository().getExtentNames(); 
        
        String storageName = System.getProperty("MDRStorageProperty." + StorageFactoryImpl.STORAGE_ID);
        if (storageName != null) {
            try {
                StorageFactoryImpl.serialize(storageName);
            } catch (StorageException e) {
            }
        }
    }

    public static Object eval ( String line ) throws Exception {
        try {
            Reader r = new StringReader(line + ";");
            return interpreter.interpret(r, line );
        } catch (Exception e) {
            ErrorManager.getDefault().notify(e);
            throw e;
        }
    }

    /**
     * Declare a bean
     */
    public static void declareVariable ( String name, Object object )  {
        interpreter.defineVariable( name, object );
    }

    private static class CLProviderImpl implements ClassLoaderProvider {
        public ClassLoader getClassLoader() {
            return interpreter.getClassLoader();
        }
        
        /** Implementation of this method can define a given class.
         * The defined class should be then visible from the ClassLoader returned
         * from {@link #getClassLoader} method.
         * @param className name of the class to define.
         * @param
         * @return Defined class or null (if null is return, MDR will define the
         * class in its own classloader. This class will then not be accessible from outside
         * of MDR
         */
        public Class defineClass(String className, byte[] classFile) {
            return interpreter.defineClass(className, classFile);
        }
    }
}
