/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is Forte for Java, Community Edition. The Initial
 * Developer of the Original Software is Sun Microsystems, Inc. Portions
 * Copyright 1997-2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.mdrxml.util;

/**
 *
 * @author  Tomas Zezula
 */
import javax.jmi.reflect.RefBaseObject;
import org.netbeans.api.looks.*;
import org.netbeans.spi.looks.*;

public class NodeEventTranslator extends EventTranslator {
    
    private XMLModelEventTranslator translator;
    private RefBaseObject key;
    
    /** Creates a new instance of NodeEventTranslator */
    public NodeEventTranslator (XMLModelEventTranslator translator, RefBaseObject key, Look.NodeSubstitute substitute) {
        super (substitute);
        this.translator = translator;
        this.key = key;
        this.translator.addNodeSubstitute (key,this);
    }
    
    /** This method is called when the node was garbage collected. You shoud
     * unregister from all objects where this object was registered as a
     * listener.
     */
    protected void unregister() {
        this.translator.removeNodeSubstitute (this.key,this);
    }    
    
    
}
