/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is Forte for Java, Community Edition. The Initial
 * Developer of the Original Software is Sun Microsystems, Inc. Portions
 * Copyright 1997-2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.mdrxml.looks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.RefBaseObject;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.netbeans.api.mdr.*;
import org.netbeans.api.looks.*;
import org.netbeans.spi.looks.*;
import xmlmodel.ElementNode;
import xmlmodel.Node;
import xmlmodel.AttributeNode;
import org.netbeans.modules.mdrxml.looks.actions.GenerateXMLAction;
import org.netbeans.modules.mdrxml.looks.actions.NewAction;
import org.netbeans.modules.mdrxml.util.XMLModelEventTranslator;
import org.netbeans.modules.mdrxml.util.NodeEventTranslator;
import org.netbeans.modules.mdrxml.util.XMLGenerator;
/**
 *
 * @author  Tomas Zezula
 */
public class ElementNodeLook extends NodeLook {
    
    private static final String ICON = "org/netbeans/modules/mdrxml/resources/elementNode";
    
    /** Creates a new instance of ElementNode */
    public ElementNodeLook() {
        this(NbBundle.getMessage(ElementNodeLook.class, "TXT_ElementNodeLook"));
    }
    
    public Object attachTo(Look.NodeSubstitute substitute) {
        super.attachTo(substitute);
        NodeEventTranslator nt = null;
        try {
            RefBaseObject mdrInstance = (javax.jmi.reflect.RefObject)substitute.getRepresentedObject();
            XMLModelEventTranslator translator = XMLModelEventTranslator.getTranslator((xmlmodel.XmlmodelPackage)mdrInstance.refImmediatePackage());
            nt = new NodeEventTranslator(translator,mdrInstance,substitute);
        }catch (javax.jmi.reflect.InvalidObjectException ioe) {
        }
        return nt;
    }
    
    public ElementNodeLook(String name) {
        super(name);
    }
    
    public String iconBase(Look.NodeSubstitute substitute) {
        return ICON;
    }
    
    public javax.swing.Action[] getActions(Look.NodeSubstitute substitute) {
        javax.swing.Action[] parentActions = super.getActions(substitute);
        javax.swing.Action[] result = new javax.swing.Action [parentActions.length + 2];
        result[0] = SystemAction.get(GenerateXMLAction.class);
        result[1] = SystemAction.get(NewAction.class);
        System.arraycopy(parentActions,0,result,2,parentActions.length);
        return result;
    }
    
    public Object[] getChildObjects(Look.NodeSubstitute substitute) {
        try {
            ElementNode en = (ElementNode) substitute.getRepresentedObject();
            MDRepository repo = ((MDRObject)en).repository();
            repo.beginTrans(false);
            try {
                Collection nodes = en.getNodes();
                Object[] result = new Object [nodes.size()];
                Iterator it = nodes.iterator();
                for (int i=0; it.hasNext(); i++) {
                    result[i] = it.next();
                }
                return result;
            }finally {
                repo.endTrans();
            }
        }catch (javax.jmi.reflect.InvalidObjectException ioe) {
            return null;
        }
    }
    
    public Transferable clipboardCopy (Look.NodeSubstitute substitute) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream ();
        new XMLGenerator ().generateXML (bos, (ElementNode)substitute.getRepresentedObject());
        return new StringSelection (bos.toString());
    }
    
}
