/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is Forte for Java, Community Edition. The Initial
 * Developer of the Original Software is Sun Microsystems, Inc. Portions
 * Copyright 1997-2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.mdrxml;

import java.util.*;

import javax.jmi.reflect.RefPackage;
import javax.jmi.model.*;

import org.openide.TopManager;
import org.openide.util.*;
import org.openide.modules.ModuleInstall;
import org.netbeans.api.mdr.*;
import xmlmodel.*;

public class MDRXMLModule extends ModuleInstall {

    // standard extent name for all MOF metamodels
    public static final String XML_METAMODEL = "org.netbeans.mof";
    // extent name for instance of metamodel of XML
    public static final String XML_MODEL = "org.netbeans.xmlmodel";
    // name of XML metamodel package
    public static final String XML_PACKAGE = "XMLModel";
    
    /** Called when module is installed for the first time.
     */
    public void installed () {
        restored();
    }

    /** Module is being loaded into the IDE.
     */
    public void restored () {
        RequestProcessor.postRequest(
            new Runnable() {
                public void run() {
                    TopManager.getDefault().setStatusText("Restoring metamodel of XML...");
                    installXML();
                    TopManager.getDefault().setStatusText("");
                }
            }
        );
    }

    /** Module was uninstalled.
     */
    public void uninstalled () {
    }

    /** Module is being closed.
     * @return True if the close is O.K.
     */
    public boolean closing () {
        return true; // agree to close
    }

    // PRIVATE METHODS ---------------------------------------------------------
    
    public static void installXML() {
        // find repository implementation using MDRManager
        MDRepository repository = MDRManager.getDefault().getDefaultRepository(); 

        // [PENDING] here I should check whether the repository was found

        // get connection to instance of XML metamodel
        if (repository.getExtent(XML_MODEL) != null) 
            return;

        // if the instance was not found, try to get an instance of MOF metamodel (standard extent for storing metamodels)
        ModelPackage xmlMMExtent = (ModelPackage) repository.getExtent(XML_METAMODEL);
        
        try {
            if (xmlMMExtent == null) {
                // if the MOF instance was not found, create it
                xmlMMExtent = (ModelPackage) repository.createExtent(XML_METAMODEL);
            }
            
            // find definition of metamodel of XML in the instance of MOF
            MofPackage xmlMMPackage = findXMLPackage(xmlMMExtent);
            
            // if it was not found, read it from its XML definition file
            if (xmlMMPackage == null) {
                // Read the XMI document
                XMIReader xmiReader = XMIReader.getDefault();
                xmiReader.read(XmlmodelPackage.class.getResource("resources/xmlmodel.xml").toString (), new RefPackage[] {xmlMMExtent});
                // after the metamodel was read, try to find its definition again
                xmlMMPackage = findXMLPackage(xmlMMExtent);
            }
            
            // create instance of the metamodel of filesystems from its definition
            repository.createExtent(XML_MODEL, xmlMMPackage);
        } catch (CreationFailedException  mer) {
            TopManager.getDefault().getErrorManager().notify (mer);
            mer.printStackTrace();
        } catch (java.io.IOException ioex) {
            TopManager.getDefault().getErrorManager().notify (ioex);
        } catch(Exception saex) {
            TopManager.getDefault().getErrorManager().notify (saex);
        }
    }
    
    private static MofPackage findXMLPackage(ModelPackage extent) {
        for (Iterator it = extent.getMofPackage().refAllOfClass().iterator(); it.hasNext();) {
            ModelElement temp = (ModelElement) it.next();
            if (temp.getName().equals(XML_PACKAGE)) {
                return (MofPackage) temp;
            }
        }

        return null;
    }        
}
