/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.jmi.xmi;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import javax.jmi.xmi.XmiReader;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.lib.jmi.util.Logger;
import org.xml.sax.SAXException;

public class XMISaxReaderImpl implements XmiReader {

    /** Creates new XMISaxReaderImpl */
    public XMISaxReaderImpl () {
    }

    public Collection read (InputStream stream, String uri, RefPackage extent) throws IOException, MalformedXMIException {
        // [PENDING] correct this code to throw exceptions correctly
        try {
            // [PENDING] correct this call to use both stream and URI
            return new XmiSAXReader ().read (stream, uri, new RefPackage[] {extent}, null);
        } catch (ParserConfigurationException e) {
            MalformedXMIException ne = new MalformedXMIException(e.getMessage());
            Logger.getDefault().annotate(ne, e);
            throw ne;
        } catch (SAXException e) {
            MalformedXMIException ne = new MalformedXMIException(e.getMessage());
            Logger.getDefault().annotate(ne, e);
            throw ne;
        }
    }
    
    public Collection read (String uri, RefPackage extent) 
    throws IOException, MalformedXMIException {
        return read (new URL(uri), new RefPackage[] {extent}, null);
    }
    
    private Collection read (URL url, RefPackage[] extents, String encoding)
        throws IOException, MalformedXMIException {
        // [PENDING] correct this code to throw exceptions correctly
        try {
            return new XmiSAXReader ().read (url, extents, encoding);
        } catch (ParserConfigurationException e) {
            MalformedXMIException ne = new MalformedXMIException(e.toString());
            Logger.getDefault().annotate(ne, e);
            throw ne;
        } catch (SAXException e) {
            MalformedXMIException ne = new MalformedXMIException(e.toString());
            Logger.getDefault().annotate(ne, e);
            throw ne;
        }
    }
    
}
