/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.jmi.xmi;

import org.netbeans.api.xmi.*;
import org.netbeans.api.xmi.sax.*;
import org.xml.sax.*;
import org.xml.sax.helpers.LocatorImpl;

import java.util.*;
import java.io.*;
import javax.jmi.reflect.RefPackage;

public class Producer extends XMIProducer {

    private XMIOutputConfig config;
    private Collection objects = null;
    private RefPackage extent = null;
    private String xmiVersion = null;
    
    private DTDHandler dtdHandler = null;
    private ContentHandler contentHandler = null;
    private EntityResolver entityResolver = null;
    private ErrorHandler errorHandler = null;
    
    private ContentHandler defaultWriter = new DefaultWriter ();
    
    // init .....................................................................
    
    public Producer () {
        config = new OutputConfig ();
    }
    
    public Producer (XMIOutputConfig config) {
        this.config = config;
    }
    
    // XMIProducer implementation ...............................................
    
    public void setSource(Collection objects) {
        this.objects = objects;
        extent = null;
    }

    public void setSource(RefPackage extent) {
        this.extent = extent;
        objects = null;
    }

    public Object getSource() {
        if (objects == null)
            return extent;
        else
            return objects;        
    }

    public void setXmiVersion(String xmiVersion) {
        this.xmiVersion = xmiVersion;
    }

    public String getXmiVersion() {
        return xmiVersion;
    }

    public XMIOutputConfig getConfiguration() {
        return config;
    }

    // XMLReader implementation .................................................
    
    public ContentHandler getContentHandler() {
        return contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return dtdHandler;
    }

    public EntityResolver getEntityResolver() {
        return entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return errorHandler;
    }

    public boolean getFeature(String name) throws SAXNotSupportedException {
        throw new SAXNotSupportedException (null);
    }

    public Object getProperty(String name) throws SAXNotSupportedException {
        throw new SAXNotSupportedException (null);
    }

    public void parse(InputSource input) throws IOException, SAXException {
        parse(input.getSystemId());
    }

    public void parse(String systemId) throws IOException, SAXException {
        ContentHandler handler = (contentHandler != null) ? contentHandler : defaultWriter;
        LocatorImpl locator = new LocatorImpl ();
        locator.setSystemId (systemId);
        handler.setDocumentLocator (locator);        
        if (extent != null) {
            getWriter ().write (contentHandler, systemId, extent, xmiVersion);
        } else if (objects != null) {
            getWriter ().write (contentHandler, systemId, objects, xmiVersion);
        } else {
            throw new SAXException ("Source not specified.");
        }
    }
   
    public void setContentHandler(ContentHandler handler) {
        contentHandler = handler;
    }

    public void setDTDHandler(DTDHandler handler) {
        dtdHandler = handler;
    }

    public void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }

    public void setErrorHandler(ErrorHandler handler) {
        errorHandler = handler;
    }

    public void setFeature(String name, boolean value) throws SAXNotSupportedException {
        throw new SAXNotSupportedException (null);
    }

    public void setProperty(String name, Object value) throws SAXNotSupportedException {
        throw new SAXNotSupportedException (null);
    }
    
    private WriterBase getWriter () {
        if ((xmiVersion != null) && xmiVersion.equals (DelegatingWriter.XMI_VERSION_20))
            return new XMI20Writer (config);
        else
            return new WriterBase (config);
    }
    
}
